/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class OperationParameterRequestConditionReader
implements OperationBuilderPlugin {
    private final TypeResolver resolver;

    @Autowired
    public OperationParameterRequestConditionReader(TypeResolver resolver) {
        this.resolver = resolver;
    }

    public void apply(OperationContext context) {
        ParamsRequestCondition paramsCondition = context.getRequestMappingInfo().getParamsCondition();
        ArrayList parameters = Lists.newArrayList();
        for (NameValueExpression expression : paramsCondition.getExpressions()) {
            if (this.skipParameter(parameters, (NameValueExpression<String>)expression)) continue;
            Parameter parameter = new ParameterBuilder().name(expression.getName()).description(null).defaultValue((String)expression.getValue()).required(true).allowMultiple(false).type(this.resolver.resolve(String.class, new Type[0])).modelRef(new ModelRef("string")).allowableValues((AllowableValues)new AllowableListValues((List)Lists.newArrayList((Object[])new String[]{(String)expression.getValue()}), "string")).parameterType("query").parameterAccess("").build();
            parameters.add(parameter);
        }
        context.operationBuilder().parameters((List)parameters);
    }

    private boolean skipParameter(List<Parameter> parameters, NameValueExpression<String> expression) {
        return expression.isNegated() || this.parameterHandled(parameters, expression);
    }

    private boolean parameterHandled(List<Parameter> parameters, NameValueExpression<String> expression) {
        return Iterables.any(parameters, this.withName(expression.getName()));
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private Predicate<? super Parameter> withName(final String name) {
        return new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return Objects.equal((Object)input.getName(), (Object)name);
            }
        };
    }
}

