/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

class Java8OptionalToGuavaOptionalConverter
implements Converter<Object, Optional<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Java8OptionalToGuavaOptionalConverter.class);

    Java8OptionalToGuavaOptionalConverter() {
    }

    public Optional<?> convert(Object source) {
        if (source != null) {
            if (this.isJdk8Optional(source)) {
                try {
                    Method optionalIsPresent = source.getClass().getDeclaredMethod("isPresent", new Class[0]);
                    optionalIsPresent.setAccessible(true);
                    Method optionalGet = source.getClass().getDeclaredMethod("get", new Class[0]);
                    optionalGet.setAccessible(true);
                    if (((Boolean)optionalIsPresent.invoke(source, new Object[0])).booleanValue()) {
                        return Optional.of((Object)optionalGet.invoke(source, new Object[0]));
                    }
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    LOGGER.warn(e.getMessage());
                }
            } else {
                return Optional.of((Object)source);
            }
            return Optional.absent();
        }
        return Optional.fromNullable((Object)source);
    }

    @VisibleForTesting
    boolean isJdk8Optional(Object source) {
        return "java.util.Optional".equals(source.getClass().getName());
    }
}

