/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityAssociationContext;
import springfox.documentation.spring.data.rest.EntityAssociationOperationsExtractor;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.RequestExtractionUtils;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;

public class EntityAssociationItemGetExtractor
implements EntityAssociationOperationsExtractor {
    @Override
    public List<RequestHandler> extract(EntityAssociationContext context) {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        ResourceMetadata metadata = context.associationMetadata();
        Association<? extends PersistentProperty<?>> association = context.getAssociation();
        PersistentProperty property = association.getInverse();
        ResourceMapping mapping = metadata.getMappingFor(property);
        EntityContext entityContext = context.getEntityContext();
        PersistentEntity<?, ?> entity = entityContext.entity();
        TypeResolver resolver = entityContext.getTypeResolver();
        RepositoryMetadata repository = entityContext.getRepositoryMetadata();
        if (property.isMap() || property.isCollectionLike()) {
            String propertyIdentifier = RequestExtractionUtils.propertyIdentifierName(property);
            ActionSpecification getPropertyItem = new ActionSpecification(String.format("%s%s", RequestExtractionUtils.lowerCamelCaseName(entity.getType().getSimpleName()), RequestExtractionUtils.upperCamelCaseName(property.getName())), String.format("%s%s/{id}/%s/{%s}", entityContext.basePath(), entityContext.resourcePath(), mapping.getPath(), propertyIdentifier), Sets.newHashSet((Object[])new RequestMethod[]{RequestMethod.GET}), new HashSet<MediaType>(), Sets.newHashSet((Object[])new MediaType[]{RestMediaTypes.HAL_JSON}), null, Lists.newArrayList((Object[])new ResolvedMethodParameter[]{new ResolvedMethodParameter(0, "id", RequestExtractionUtils.pathAnnotations("id"), resolver.resolve((Type)repository.getIdType(), new Type[0])), new ResolvedMethodParameter(1, propertyIdentifier, RequestExtractionUtils.pathAnnotations(propertyIdentifier), resolver.resolve(String.class, new Type[0]))}), RequestExtractionUtils.propertyItemResponse(property, resolver));
            handlers.add(new SpringDataRestRequestHandler(entityContext, getPropertyItem));
        }
        return handlers;
    }
}

