/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Types;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.RequestExtractionUtils;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;
import springfox.documentation.spring.data.rest.SynthesizedAnnotations;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

class EntitySearchExtractor
implements EntityOperationsExtractor {
    EntitySearchExtractor() {
    }

    @Override
    public List<RequestHandler> extract(EntityContext context) {
        ArrayList handlers = Lists.newArrayList();
        PersistentEntity<?, ?> entity = context.entity();
        HandlerMethodResolver methodResolver = new HandlerMethodResolver(context.getTypeResolver());
        SearchResourceMappings searchMappings = context.searchMappings();
        for (MethodResourceMapping mapping : searchMappings.getExportedMappings()) {
            HandlerMethod handler = new HandlerMethod(context.getRepositoryInstance(), mapping.getMethod());
            ActionSpecification spec = new ActionSpecification(RequestExtractionUtils.actionName(entity, mapping.getMethod()), String.format("%s%s/search%s", context.basePath(), context.resourcePath(), mapping.getPath()), Sets.newHashSet((Object[])new RequestMethod[]{RequestMethod.GET}), new HashSet<MediaType>(), new HashSet<MediaType>(), handler, this.transferResolvedMethodParameterList(methodResolver.methodParameters(handler)), this.inferReturnType(methodResolver, handler, context.getTypeResolver()));
            handlers.add(new SpringDataRestRequestHandler(context, spec));
        }
        return handlers;
    }

    private ResolvedType inferReturnType(HandlerMethodResolver methodResolver, HandlerMethod handler, TypeResolver resolver) {
        ResolvedType returnType = methodResolver.methodReturnType(handler);
        if (Collections.isContainerType((ResolvedType)returnType)) {
            return resolver.resolve(Resources.class, new Type[]{returnType});
        }
        if (Types.isBaseType((ResolvedType)returnType)) {
            return returnType;
        }
        return resolver.resolve(Resource.class, new Type[]{returnType});
    }

    private List<ResolvedMethodParameter> transferResolvedMethodParameterList(List<ResolvedMethodParameter> srcList) {
        ArrayList<ResolvedMethodParameter> targetList = new ArrayList<ResolvedMethodParameter>(srcList.size());
        for (ResolvedMethodParameter resolvedMethodParameter : srcList) {
            targetList.add(this.transferResolvedMethodParameter(resolvedMethodParameter));
        }
        return targetList;
    }

    private ResolvedMethodParameter transferResolvedMethodParameter(ResolvedMethodParameter src) {
        Optional param = src.findAnnotation(Param.class);
        if (param.isPresent()) {
            return src.annotate((Annotation)SynthesizedAnnotations.requestParam(((Param)param.get()).value()));
        }
        return src;
    }
}

