/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.spring.data.rest.EntitySearchRequestHandler;

class EntitySearchRequestTemplate {
    private final TypeResolver resolver;
    private final ResourceMappings mappings;
    private final RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;

    EntitySearchRequestTemplate(TypeResolver resolver, ResourceMappings mappings, RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.resolver = resolver;
        this.mappings = mappings;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    Collection<? extends RequestHandler> operations() {
        ArrayList requestHandlers = Lists.newArrayList();
        boolean collectionHandlerAdded = false;
        for (ResourceMetadata resource : this.mappings) {
            for (MethodResourceMapping searchResource : resource.getSearchResourceMappings()) {
                EntitySearchRequestHandler handler = new EntitySearchRequestHandler(this.resolver, this.requestMapping, this.handlerMethod, searchResource, resource);
                if (handler.resourceType() != ResourceType.ITEM && collectionHandlerAdded) continue;
                requestHandlers.add(handler);
                if (collectionHandlerAdded) continue;
                collectionHandlerAdded = handler.resourceType() == ResourceType.COLLECTION;
            }
        }
        return requestHandlers;
    }
}

