/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Map;
import org.springframework.data.rest.webmvc.RepositoryController;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

class EntityServices {
    private EntityServices() {
        throw new UnsupportedOperationException();
    }

    static Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>> restDataServices() {
        return Predicates.or((Predicate[])new Predicate[]{EntityServices.repositories(), EntityServices.entityServices(), EntityServices.entitySearchServices(), EntityServices.entityRelationshipsServices()});
    }

    static Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>> repositories() {
        return new Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>>(){

            public boolean apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return RepositoryController.class.equals((Object)input.getValue().getBeanType());
            }
        };
    }

    static Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>> entityServices() {
        return new Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>>(){

            public boolean apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return input.getValue().getBeanType().getSimpleName().equals("RepositoryEntityController");
            }
        };
    }

    static Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>> entitySearchServices() {
        return new Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>>(){

            public boolean apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return input.getValue().getBeanType().getSimpleName().equals("RepositorySearchController");
            }
        };
    }

    static Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>> entityRelationshipsServices() {
        return new Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>>(){

            public boolean apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return input.getValue().getBeanType().getSimpleName().equals("RepositoryPropertyReferenceController");
            }
        };
    }

    static Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>> entitySchemaService() {
        return new Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>>(){

            public boolean apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return input.getValue().getBeanType().getSimpleName().equals("RepositorySchemaController");
            }
        };
    }

    static Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>> alpsProfileServices() {
        return new Predicate<Map.Entry<RequestMappingInfo, HandlerMethod>>(){

            public boolean apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return AlpsController.class.equals((Object)input.getValue().getBeanType());
            }
        };
    }
}

