/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.SynthesizedAnnotations;
import springfox.documentation.spring.web.paths.Paths;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

class EntityRequestHandler
implements RequestHandler {
    private static final List<MediaType> COLLECTION_COMPACT_MEDIA_TYPES = Lists.newArrayList((Object[])new MediaType[]{MediaType.valueOf((String)"application/x-spring-data-compact+json"), MediaType.valueOf((String)"text/uri-list")});
    private final ResourceMetadata resource;
    private final ResourceType resourceType;
    private final Class<? extends Serializable> idType;
    private final Class<?> domainType;
    private final RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;
    private final TypeResolver resolver;

    EntityRequestHandler(TypeResolver resolver, ResourceMetadata resource, Class<? extends Serializable> idType, Class<?> domainType, RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.resolver = resolver;
        this.resource = resource;
        this.idType = idType;
        this.domainType = domainType;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
        this.resourceType = this.resourceType();
    }

    public Class<?> declaringClass() {
        return this.handlerMethod.getBeanType();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        PatternsRequestCondition repositoryPatterns = this.requestMapping.getPatternsCondition();
        HashSet patterns = Sets.newHashSet();
        for (String each : repositoryPatterns.getPatterns()) {
            patterns.add(each.replace("{repository}", this.resource.getPath().toString()));
        }
        return new PatternsRequestCondition(patterns.toArray(new String[patterns.size()]));
    }

    public String groupName() {
        return String.format("%s Entity", Paths.splitCamelCase((String)this.resource.getDomainType().getSimpleName(), (String)""));
    }

    public String getName() {
        return this.handlerMethod.getMethod().getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    public Set<? extends MediaType> produces() {
        return this.requestMapping.getProducesCondition().getProducibleMediaTypes();
    }

    public Set<? extends MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    public Set<NameValueExpression<String>> headers() {
        return this.requestMapping.getHeadersCondition().getExpressions();
    }

    public Set<NameValueExpression<String>> params() {
        return this.requestMapping.getParamsCondition().getExpressions();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.requestMapping.getPatternsCondition().getPatterns(), this.requestMapping.getMethodsCondition().getMethods(), this.requestMapping.getConsumesCondition().getConsumableMediaTypes(), this.requestMapping.getProducesCondition().getProducibleMediaTypes());
    }

    public List<ResolvedMethodParameter> getParameters() {
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(this.resolver);
        return FluentIterable.from((Iterable)handlerMethodResolver.methodParameters(this.handlerMethod)).transform(this.toEntitySpecificParameters()).toList();
    }

    private Function<ResolvedMethodParameter, ResolvedMethodParameter> toEntitySpecificParameters() {
        return new Function<ResolvedMethodParameter, ResolvedMethodParameter>(){

            public ResolvedMethodParameter apply(ResolvedMethodParameter input) {
                if (EntityRequestHandler.this.isIdParameter(input)) {
                    return EntityRequestHandler.this.transformToId(input);
                }
                if (EntityRequestHandler.this.isDomainParameter(input)) {
                    return EntityRequestHandler.this.transformToDomainType(input);
                }
                return input.annotate((Annotation)SynthesizedAnnotations.API_IGNORE_ANNOTATION);
            }
        };
    }

    private ResolvedMethodParameter transformToDomainType(ResolvedMethodParameter input) {
        return input.replaceResolvedParameterType(this.resolver.resolve(this.domainType, new Type[0])).annotate((Annotation)SynthesizedAnnotations.REQUEST_BODY_ANNOTATION);
    }

    private boolean isDomainParameter(ResolvedMethodParameter input) {
        return PersistentEntityResource.class.equals((Object)input.getParameterType().getErasedType());
    }

    private ResolvedMethodParameter transformToId(ResolvedMethodParameter idParam) {
        return idParam.replaceResolvedParameterType(this.resolver.resolve(this.idType, new Type[0])).annotate((Annotation)SynthesizedAnnotations.PATH_VARIABLE_ANNOTATION);
    }

    private boolean isIdParameter(ResolvedMethodParameter input) {
        return input.hasParameterAnnotation(BackendId.class);
    }

    public ResolvedType getReturnType() {
        if (this.resourceType == ResourceType.COLLECTION) {
            if (COLLECTION_COMPACT_MEDIA_TYPES.containsAll(this.requestMapping.getProducesCondition().getProducibleMediaTypes())) {
                return this.resolver.resolve(Resources.class, new Type[]{Link.class});
            }
            if (this.requestMapping.getMethodsCondition().getMethods().contains(RequestMethod.HEAD) || this.requestMapping.getMethodsCondition().getMethods().contains(RequestMethod.OPTIONS)) {
                return this.resolver.resolve(Void.TYPE, new Type[0]);
            }
            if (this.requestMapping.getMethodsCondition().getMethods().contains(RequestMethod.POST)) {
                return this.resolver.resolve(Resource.class, new Type[]{this.domainType});
            }
            return this.resolver.resolve(Resources.class, new Type[]{this.domainType});
        }
        if (this.requestMapping.getMethodsCondition().getMethods().contains(RequestMethod.GET) || this.requestMapping.getMethodsCondition().getMethods().contains(RequestMethod.PUT) || this.requestMapping.getMethodsCondition().getMethods().contains(RequestMethod.PATCH)) {
            return this.resolver.resolve(Resource.class, new Type[]{this.domainType});
        }
        return this.resolver.resolve(Void.TYPE, new Type[0]);
    }

    private ResourceType resourceType() {
        if (this.requestMapping.getPatternsCondition().getPatterns().contains("/{search}")) {
            return ResourceType.ITEM;
        }
        return ResourceType.COLLECTION;
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)this.handlerMethod.getBeanType(), annotation));
    }

    public RequestMappingInfo getRequestMapping() {
        return this.requestMapping;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public RequestHandler combine(RequestHandler other) {
        return this;
    }
}

