/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Types;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityAssociationContext;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.RequestExtractionUtils;
import springfox.documentation.spring.data.rest.SynthesizedAnnotations;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

abstract class SpecificationBuilder {
    private final Set<RequestMethod> supportedMethods = new HashSet<RequestMethod>();
    private final Set<MediaType> produces = new HashSet<MediaType>();
    private final Set<MediaType> consumes = new HashSet<MediaType>();
    private final List<ResolvedMethodParameter> parameters = new ArrayList<ResolvedMethodParameter>();
    private String path;

    SpecificationBuilder() {
    }

    static ResolvedType resolveType(EntityContext context, Function<RepositoryMetadata, Type> getType) {
        RepositoryMetadata repository = context.getRepositoryMetadata();
        TypeResolver typeResolver = context.getTypeResolver();
        return getType != null ? typeResolver.resolve(getType.apply(repository), new Type[0]) : typeResolver.resolve(Void.TYPE, new Type[0]);
    }

    static SpecificationBuilder entityAction(EntityContext context, HandlerMethod handlerMethod) {
        return new EntityActionSpecificationBuilder(context, handlerMethod);
    }

    static SpecificationBuilder associationAction(EntityAssociationContext context, String path) {
        return new AssociationActionSpecificationBuilder(context, path);
    }

    SpecificationBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    SpecificationBuilder supportsMethod(RequestMethod method) {
        this.supportedMethods.add(method);
        return this;
    }

    SpecificationBuilder produces(MediaType type) {
        this.produces.add(type);
        return this;
    }

    SpecificationBuilder consumes(MediaType type) {
        this.consumes.add(type);
        return this;
    }

    SpecificationBuilder withParameter(ResolvedMethodParameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public Set<RequestMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    public Set<MediaType> getProduces() {
        return this.produces;
    }

    public Set<MediaType> getConsumes() {
        return this.consumes;
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    abstract SpecificationBuilder withParameterType(ParameterType var1);

    abstract Optional<ActionSpecification> build();

    private static class EntityActionSpecificationBuilder
    extends SpecificationBuilder {
        private final EntityContext context;
        private final HandlerMethod handlerMethod;

        EntityActionSpecificationBuilder(EntityContext context, HandlerMethod handlerMethod) {
            this.context = context;
            this.handlerMethod = handlerMethod;
        }

        private static ResolvedMethodParameter transferResolvedMethodParameter(ResolvedMethodParameter src) {
            Optional param = src.findAnnotation(Param.class);
            if (param.isPresent()) {
                return src.annotate((Annotation)SynthesizedAnnotations.requestParam(((Param)param.get()).value()));
            }
            return src;
        }

        @Override
        SpecificationBuilder withParameterType(ParameterType parameterType) {
            switch (parameterType) {
                case ID: {
                    return this.withParameter(new ResolvedMethodParameter(0, "id", RequestExtractionUtils.pathAnnotations("id", this.handlerMethod), EntityActionSpecificationBuilder.resolveType(this.context, RepositoryMetadata::getIdType)));
                }
                case RESOURCE: {
                    return this.withParameter(new ResolvedMethodParameter(0, "body", RequestExtractionUtils.bodyAnnotations(this.handlerMethod), EntityActionSpecificationBuilder.resolveType(this.context, RepositoryMetadata::getDomainType)));
                }
                case PAGEABLE_RESOURCE: {
                    RepositoryRestConfiguration configuration = this.context.getConfiguration();
                    TypeResolver typeResolver = this.context.getTypeResolver();
                    this.withParameter(new ResolvedMethodParameter(0, configuration.getPageParamName(), java.util.Collections.EMPTY_LIST, typeResolver.resolve(Integer.class, new Type[0])));
                    this.withParameter(new ResolvedMethodParameter(1, configuration.getLimitParamName(), java.util.Collections.EMPTY_LIST, typeResolver.resolve(Integer.class, new Type[0])));
                    this.withParameter(new ResolvedMethodParameter(2, configuration.getSortParamName(), java.util.Collections.EMPTY_LIST, typeResolver.resolve(String.class, new Type[0])));
                }
            }
            return this;
        }

        @Override
        Optional<ActionSpecification> build() {
            if (!StringUtils.hasText((String)this.getPath())) {
                this.setPath(String.format("%s%s", this.context.basePath(), this.context.resourcePath()));
            }
            return this.context.entity().map(entity -> RequestExtractionUtils.actionName(entity, this.handlerMethod.getMethod())).map(actionName -> new ActionSpecification((String)actionName, this.getPath(), (Collection<RequestMethod>)this.getSupportedMethods(), this.getProduces(), this.getConsumes(), this.handlerMethod, this.getType(), this.inputParameters(), this.inferReturnType(this.context, this.handlerMethod)));
        }

        private ResolvedType inferReturnType(EntityContext context, HandlerMethod handler) {
            TypeResolver resolver = context.getTypeResolver();
            HandlerMethodResolver methodResolver = new HandlerMethodResolver(resolver);
            RepositoryMetadata repository = context.getRepositoryMetadata();
            ResolvedType domainReturnType = resolver.resolve((Type)repository.getReturnedDomainClass(handler.getMethod()), new Type[0]);
            ResolvedType methodReturnType = methodResolver.methodReturnType(handler);
            if (Collections.isContainerType((ResolvedType)methodReturnType)) {
                return resolver.resolve(CollectionModel.class, new Type[]{Collections.collectionElementType((ResolvedType)methodReturnType)});
            }
            if (Iterable.class.isAssignableFrom(methodReturnType.getErasedType())) {
                return resolver.resolve(CollectionModel.class, new Type[]{domainReturnType});
            }
            if (Types.isBaseType((ResolvedType)domainReturnType)) {
                return domainReturnType;
            }
            if (Types.isVoid((ResolvedType)domainReturnType)) {
                return resolver.resolve(Void.TYPE, new Type[0]);
            }
            return resolver.resolve(EntityModel.class, new Type[]{domainReturnType});
        }

        private List<ResolvedMethodParameter> transferResolvedMethodParameterList(EntityContext context, HandlerMethod handler) {
            TypeResolver resolver = context.getTypeResolver();
            HandlerMethodResolver methodResolver = new HandlerMethodResolver(resolver);
            return methodResolver.methodParameters(handler).stream().map(EntityActionSpecificationBuilder::transferResolvedMethodParameter).collect(Collectors.toList());
        }

        private Class<?> getType() {
            return this.context.entity().get().getType();
        }

        private List<ResolvedMethodParameter> inputParameters() {
            return !this.getParameters().isEmpty() ? this.getParameters() : this.transferResolvedMethodParameterList(this.context, this.handlerMethod);
        }
    }

    private static class AssociationActionSpecificationBuilder
    extends SpecificationBuilder {
        private final EntityAssociationContext context;
        private final PersistentProperty<?> property;

        AssociationActionSpecificationBuilder(EntityAssociationContext context, String path) {
            this.setPath(path);
            this.context = context;
            this.property = context.getAssociation().getInverse();
        }

        @Override
        SpecificationBuilder withParameterType(ParameterType parameterType) {
            int index = this.getParameters().size();
            switch (parameterType) {
                case ID: {
                    return this.withParameter(new ResolvedMethodParameter(0, "id", RequestExtractionUtils.pathAnnotations("id"), AssociationActionSpecificationBuilder.resolveType(this.context.getEntityContext(), RepositoryMetadata::getIdType)));
                }
                case RESOURCE: {
                    return this.withParameter(new ResolvedMethodParameter(0, "body", RequestExtractionUtils.bodyAnnotations(), this.property.isCollectionLike() ? this.context.getEntityContext().getTypeResolver().resolve(List.class, new Type[]{String.class}) : this.context.getEntityContext().getTypeResolver().resolve(String.class, new Type[0])));
                }
                case ASSOCIATION: {
                    return this.withParameter(new ResolvedMethodParameter(index, RequestExtractionUtils.propertyIdentifierName(this.property), RequestExtractionUtils.pathAnnotations(RequestExtractionUtils.propertyIdentifierName(this.property)), this.context.getEntityContext().getTypeResolver().resolve(String.class, new Type[0])));
                }
            }
            return this;
        }

        @Override
        Optional<ActionSpecification> build() {
            TypeResolver resolver = this.context.getEntityContext().getTypeResolver();
            return this.context.getEntityContext().entity().map(entity -> this.actionName((PersistentEntity<?, ?>)entity, this.property)).map(actionName -> new ActionSpecification((String)actionName, this.getPath(), (Collection<RequestMethod>)this.getSupportedMethods(), this.getProduces(), this.getConsumes(), null, this.getType(), this.getParameters(), this.returnType(resolver)));
        }

        private String actionName(PersistentEntity<?, ?> entity, PersistentProperty<?> property) {
            return String.format("%s%s", RequestExtractionUtils.lowerCamelCaseName(entity.getType().getSimpleName()), RequestExtractionUtils.upperCamelCaseName(property.getName()));
        }

        private Class<?> getType() {
            return this.context.getEntityContext().entity().get().getType();
        }

        private ResolvedType returnType(TypeResolver resolver) {
            return this.getSupportedMethods().contains(RequestMethod.DELETE) ? resolver.resolve(Void.TYPE, new Type[0]) : (this.getParameters().stream().anyMatch(param -> param.getParameterIndex() > 0) ? RequestExtractionUtils.propertyItemResponse(this.property, resolver) : RequestExtractionUtils.propertyResponse(this.property, resolver));
        }
    }

    static enum ParameterType {
        ID,
        RESOURCE,
        PAGEABLE_RESOURCE,
        ASSOCIATION;

    }
}

