/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Xml;

public class ModelBuilder {
    private final String id;
    private String name;
    private String qualifiedType;
    private String description;
    private String baseModel;
    private String discriminator;
    private ResolvedType modelType;
    private Object example;
    private Xml xml;
    private Map<String, ModelProperty> properties = new HashMap<String, ModelProperty>();
    private List<ModelReference> subTypes = new ArrayList<ModelReference>();

    public ModelBuilder(Model model) {
        this.id = model.getId();
        this.name = model.getName();
        this.qualifiedType = model.getQualifiedType();
        this.description = model.getDescription();
        this.baseModel = model.getBaseModel();
        this.discriminator = model.getDiscriminator();
        this.modelType = model.getType();
        this.example = model.getExample();
        this.xml = model.getXml();
        this.properties.putAll(model.getProperties());
        this.subTypes.addAll(model.getSubTypes());
    }

    public ModelBuilder(String id) {
        this.id = id;
    }

    public ModelBuilder name(String name) {
        this.name = BuilderDefaults.defaultIfAbsent(name, this.name);
        return this;
    }

    public ModelBuilder qualifiedType(String qualifiedType) {
        this.qualifiedType = BuilderDefaults.defaultIfAbsent(qualifiedType, this.qualifiedType);
        return this;
    }

    public ModelBuilder properties(Map<String, ModelProperty> properties) {
        if (properties != null) {
            this.properties = new HashMap<String, ModelProperty>(properties);
        }
        return this;
    }

    public ModelBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ModelBuilder baseModel(String baseModel) {
        this.baseModel = BuilderDefaults.defaultIfAbsent(baseModel, this.baseModel);
        return this;
    }

    public ModelBuilder discriminator(String discriminator) {
        this.discriminator = BuilderDefaults.defaultIfAbsent(discriminator, this.discriminator);
        return this;
    }

    public ModelBuilder subTypes(List<ModelReference> subTypes) {
        if (subTypes != null) {
            this.subTypes = new ArrayList<ModelReference>(subTypes);
        }
        return this;
    }

    @Deprecated
    public ModelBuilder example(String example) {
        this.example = BuilderDefaults.defaultIfAbsent(example, this.example);
        return this;
    }

    public ModelBuilder example(Object example) {
        this.example = BuilderDefaults.defaultIfAbsent(example, this.example);
        return this;
    }

    public ModelBuilder type(ResolvedType modelType) {
        this.modelType = BuilderDefaults.defaultIfAbsent(modelType, this.modelType);
        return this;
    }

    public ModelBuilder xml(Xml xml) {
        this.xml = BuilderDefaults.defaultIfAbsent(xml, this.xml);
        return this;
    }

    public Model build() {
        if (this.xml != null && StringUtils.isEmpty((Object)this.xml.getName())) {
            this.xml.setName(this.name);
        }
        return new Model(this.id, this.name, this.modelType, this.qualifiedType, Collections.unmodifiableMap(this.properties), this.description, this.baseModel, this.discriminator, Collections.unmodifiableList(this.subTypes), this.example, this.xml);
    }
}

