/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.VendorExtension;

public class ModelProperty {
    private final String name;
    private final ResolvedType type;
    private final String qualifiedType;
    private final int position;
    private final Boolean required;
    private final boolean isHidden;
    private final Boolean readOnly;
    private final Boolean allowEmptyValue;
    private final String description;
    private final AllowableValues allowableValues;
    private ModelReference modelRef;
    private final Object example;
    private final String pattern;
    private final String defaultValue;
    private final Xml xml;
    private final List<VendorExtension> vendorExtensions;

    public ModelProperty(String name, ResolvedType type, String qualifiedType, int position, boolean required, boolean isHidden, boolean readOnly, Boolean allowEmptyValue, String description, AllowableValues allowableValues, Object example, String pattern, String defaultValue, Xml xml, List<VendorExtension> vendorExtensions) {
        this.name = name;
        this.type = type;
        this.qualifiedType = qualifiedType;
        this.position = position;
        this.required = required;
        this.isHidden = isHidden;
        this.readOnly = readOnly;
        this.allowEmptyValue = allowEmptyValue;
        this.description = description;
        this.allowableValues = allowableValues;
        this.example = example;
        this.pattern = pattern;
        this.defaultValue = defaultValue;
        this.xml = xml;
        this.vendorExtensions = new ArrayList<VendorExtension>(vendorExtensions);
    }

    public String getName() {
        return this.name;
    }

    public ResolvedType getType() {
        return this.type;
    }

    public String getQualifiedType() {
        return this.qualifiedType;
    }

    public int getPosition() {
        return this.position;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public AllowableValues getAllowableValues() {
        return this.allowableValues;
    }

    public ModelReference getModelRef() {
        return this.modelRef;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public ModelProperty updateModelRef(Function<ResolvedType, ? extends ModelReference> modelRefFactory) {
        this.modelRef = modelRefFactory.apply(this.type);
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<VendorExtension> getVendorExtensions() {
        return this.vendorExtensions;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Xml getXml() {
        return this.xml;
    }

    public Boolean isAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.qualifiedType, this.position, this.required, this.isHidden, this.readOnly, this.allowableValues, this.description, this.allowableValues, this.modelRef, this.example, this.pattern, this.defaultValue, this.xml, Collections.unmodifiableList(this.vendorExtensions));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelProperty that = (ModelProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.qualifiedType, that.qualifiedType) && Objects.equals(this.position, that.position) && Objects.equals(this.required, that.required) && Objects.equals(this.isHidden, that.isHidden) && Objects.equals(this.readOnly, that.readOnly) && Objects.equals(this.description, that.description) && Objects.equals(this.allowableValues, that.allowableValues) && Objects.equals(this.modelRef, that.modelRef) && Objects.equals(this.example, that.example) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.xml, that.xml) && Objects.equals(this.allowEmptyValue, that.allowEmptyValue) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.vendorExtensions, that.vendorExtensions);
    }
}

