/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.Parameters;
import springfox.documentation.service.Parameter;

class ParameterMerger {
    private final List<Parameter> destination;
    private final List<Parameter> source;

    ParameterMerger(List<Parameter> destination, List<Parameter> source) {
        this.destination = new ArrayList<Parameter>(destination);
        this.source = new ArrayList<Parameter>(source);
    }

    public List<Parameter> merged() {
        Set existingParameterNames = this.destination.stream().map(Parameters.toParameterName()).collect(Collectors.toSet());
        Set newParameterNames = this.source.stream().map(Parameters.toParameterName()).collect(Collectors.toSet());
        ArrayList<Parameter> merged = new ArrayList<Parameter>();
        Set<String> asIsParams = existingParameterNames.stream().filter(entry -> !newParameterNames.contains(entry)).collect(Collectors.toSet());
        Set<String> missingParamNames = newParameterNames.stream().filter(entry -> !existingParameterNames.contains(entry)).collect(Collectors.toSet());
        Set<String> paramsToMerge = newParameterNames.stream().filter(existingParameterNames::contains).collect(Collectors.toSet());
        merged.addAll(this.asIsParameters(asIsParams, this.destination));
        merged.addAll(this.newParameters(missingParamNames, this.source));
        merged.addAll(this.mergedParameters(paramsToMerge, this.destination, this.source));
        return merged;
    }

    private List<Parameter> asIsParameters(Set<String> asIsParams, List<Parameter> source) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter each : source) {
            if (!asIsParams.contains(each.getName())) continue;
            parameters.add(each);
        }
        return parameters;
    }

    private List<Parameter> mergedParameters(Set<String> paramsToMerge, List<Parameter> existingParameters, List<Parameter> newParams) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter newParam : newParams) {
            Optional<Parameter> original = existingParameters.stream().filter(Parameters.withName(newParam.getName())).findFirst();
            if (!paramsToMerge.contains(newParam.getName()) || !original.isPresent()) continue;
            if (newParam.getOrder() > original.get().getOrder()) {
                parameters.add(this.merged(newParam, original.get()));
                continue;
            }
            parameters.add(this.merged(original.get(), newParam));
        }
        return parameters;
    }

    private Parameter merged(Parameter destination, Parameter source) {
        return new ParameterBuilder().from(destination).name(source.getName()).allowableValues(source.getAllowableValues()).allowMultiple(source.isAllowMultiple()).defaultValue(source.getDefaultValue()).description(source.getDescription()).modelRef(source.getModelRef()).parameterAccess(source.getParamAccess()).parameterType(source.getParamType()).required(source.isRequired()).type(source.getType().orElse(null)).order(source.getOrder()).scalarExample(source.getScalarExample()).complexExamples(source.getExamples()).collectionFormat(source.getCollectionFormat()).build();
    }

    private List<Parameter> newParameters(Set<String> missingParamNames, List<Parameter> newParams) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter each : newParams) {
            if (!missingParamNames.contains(each.getName())) continue;
            parameters.add(each);
        }
        return parameters;
    }
}

