/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.google.common.base.Optional;

public class ModelRef {
    private final String type;
    private final boolean isMap;
    private final Optional<String> itemType;

    public ModelRef(String type, String itemType) {
        this(type, itemType, false);
    }

    public ModelRef(String type, String itemType, boolean isMap) {
        this.type = type;
        this.isMap = isMap;
        this.itemType = Optional.fromNullable((Object)itemType);
    }

    public ModelRef(String type) {
        this(type, null);
    }

    public String getType() {
        return this.type;
    }

    public boolean isCollection() {
        return this.itemType.isPresent() && !this.isMap;
    }

    public boolean isMap() {
        return this.itemType.isPresent() && this.isMap;
    }

    public String getItemType() {
        return (String)this.itemType.orNull();
    }
}

