/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Tag;

public class DocumentationBuilder {
    private String groupName;
    private Map<String, ApiListing> apiListings = Maps.newTreeMap();
    private ResourceListing resourceListing;
    private Set<Tag> tags = Sets.newHashSet();
    private String basePath;
    private Set<String> produces = Sets.newHashSet();
    private Set<String> consumes = Sets.newHashSet();
    private Set<String> schemes = Sets.newHashSet();

    public DocumentationBuilder name(String groupName) {
        this.groupName = BuilderDefaults.defaultIfAbsent(groupName, this.groupName);
        return this;
    }

    public DocumentationBuilder apiListingsByResourceGroupName(Map<String, ApiListing> apiListings) {
        this.apiListings.putAll(BuilderDefaults.nullToEmptyMap(apiListings));
        return this;
    }

    public DocumentationBuilder resourceListing(ResourceListing resourceListing) {
        this.resourceListing = BuilderDefaults.defaultIfAbsent(resourceListing, this.resourceListing);
        return this;
    }

    public DocumentationBuilder tags(Set<Tag> tags) {
        this.tags.addAll(BuilderDefaults.nullToEmptySet(tags));
        return this;
    }

    public DocumentationBuilder produces(Set<String> mediaTypes) {
        this.produces.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public DocumentationBuilder consumes(Set<String> mediaTypes) {
        this.consumes.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public DocumentationBuilder schemes(Set<String> schemes) {
        this.schemes.addAll(BuilderDefaults.nullToEmptySet(schemes));
        return this;
    }

    public DocumentationBuilder basePath(String basePath) {
        this.basePath = BuilderDefaults.defaultIfAbsent(basePath, this.basePath);
        return this;
    }

    public Documentation build() {
        return new Documentation(this.groupName, this.basePath, this.tags, this.apiListings, this.resourceListing, this.produces, this.consumes, this.schemes);
    }
}

