/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import com.google.common.base.Optional;
import javax.validation.constraints.Pattern;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class PatternAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public void apply(ModelPropertyContext context) {
        Optional<Pattern> pattern = Validators.extractAnnotation(context, Pattern.class);
        context.getBuilder().pattern(this.createPatternValueFromAnnotation(pattern));
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String createPatternValueFromAnnotation(Optional<Pattern> pattern) {
        String patternValue = null;
        if (pattern.isPresent()) {
            patternValue = ((Pattern)pattern.get()).regexp();
        }
        return patternValue;
    }
}

