/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RolePersistService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedRolePersistServiceImpl
implements RolePersistService {
    @Autowired
    private DatabaseOperate databaseOperate;
    @Autowired
    private EmbeddedStoragePersistServiceImpl persistService;

    @Override
    public Page<RoleInfo> getRoles(int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM (SELECT DISTINCT role FROM roles) roles WHERE ";
        String sqlFetchRows = "SELECT role,username FROM roles WHERE ";
        String where = " 1=1 ";
        Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, new ArrayList().toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
        if (pageInfo == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public Page<RoleInfo> getRolesByUserName(String username, int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM roles WHERE ";
        String sqlFetchRows = "SELECT role,username FROM roles WHERE ";
        String where = " username= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((String)username)) {
            params = Collections.singletonList(username);
        } else {
            where = " 1=1 ";
        }
        return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(String role, String userName) {
        String sql = "INSERT INTO roles (role, username) VALUES (?, ?)";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role, userName});
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void deleteRole(String role) {
        String sql = "DELETE FROM roles WHERE role=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role});
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRole(String role, String username) {
        String sql = "DELETE FROM roles WHERE role=? AND username=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role, username});
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public List<String> findRolesLikeRoleName(String role) {
        String sql = "SELECT role FROM roles WHERE role LIKE ? ";
        return this.databaseOperate.queryMany(sql, (Object[])new String[]{"%" + role + "%"}, String.class);
    }
}

