/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.Repository;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class CheckBranchHasCommercialSupportTask
extends DefaultTask {
    public static final String TASK_NAME = "checkBranchHasCommercialSupport";

    @Input
    public abstract Property<Repository> getRepository();

    @Input
    public abstract Property<String> getBranch();

    @Input
    @Optional
    public abstract Property<String> getGitHubAccessToken();

    @TaskAction
    public void checkMilestoneHasNoOpenIssues() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().getOrNull();
        Repository repository = (Repository)this.getRepository().get();
        String branch = (String)this.getBranch().get();
        SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
        boolean hasCommercialSupport = springReleases.hasCommercialSupport(repository.name(), branch);
        System.out.println(hasCommercialSupport);
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + String.valueOf(SpringReleasePluginExtension.class));
        project.getTasks().register(TASK_NAME, CheckBranchHasCommercialSupportTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Checks if the specified branch has commercial support and outputs true or false");
            task.doNotTrackState("API call to api.spring.io needs to check every time");
            String owner = (String)springRelease.getRepositoryOwner().get();
            String name = (String)springRelease.getRepositoryName().get();
            task.getRepository().set((Object)new Repository(owner, name));
            task.getBranch().set(ProjectUtils.getProperty(project, "branch"));
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
        });
    }
}

