/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.provider.agent;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.ListRolesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolesResult;
import com.amazonaws.services.identitymanagement.model.Role;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.lambda.cache.Keys;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.IamRole;
import com.netflix.spinnaker.clouddriver.lambda.provider.agent.IamTrustRelationship;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamRoleCachingAgent
implements CachingAgent,
CustomScheduledAgent {
    private static final long POLL_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Collection<AgentDataType> types = Collections.singletonList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.IAM_ROLE.toString()));
    private final ObjectMapper objectMapper;
    private AmazonClientProvider amazonClientProvider;
    private NetflixAmazonCredentials account;
    private String accountName;

    IamRoleCachingAgent(ObjectMapper objectMapper, NetflixAmazonCredentials account, AmazonClientProvider amazonClientProvider) {
        this.objectMapper = objectMapper;
        this.account = account;
        this.accountName = account.getName();
        this.amazonClientProvider = amazonClientProvider;
    }

    public String getAgentType() {
        return this.accountName + "/" + this.getClass().getSimpleName();
    }

    public String getProviderName() {
        return AwsProvider.PROVIDER_NAME;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.types;
    }

    public long getPollIntervalMillis() {
        return POLL_INTERVAL_MILLIS;
    }

    public long getTimeoutMillis() {
        return DEFAULT_TIMEOUT_MILLIS;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        AmazonIdentityManagement iam = this.amazonClientProvider.getIam(this.account, Regions.DEFAULT_REGION.getName(), false);
        Set<IamRole> cacheableRoles = this.fetchIamRoles(iam, this.accountName);
        Map<String, Collection<CacheData>> newDataMap = this.generateFreshData(cacheableRoles);
        Collection<CacheData> newData = newDataMap.get(Keys.Namespace.IAM_ROLE.toString());
        Set<String> oldKeys = providerCache.getAll(Keys.Namespace.IAM_ROLE.toString()).stream().map(CacheData::getId).filter(this::keyAccountFilter).collect(Collectors.toSet());
        Map<String, Collection<String>> evictionsByKey = this.computeEvictableData(newData, oldKeys);
        this.logUpcomingActions(newDataMap, evictionsByKey);
        return new DefaultCacheResult(newDataMap, evictionsByKey);
    }

    private void logUpcomingActions(Map<String, Collection<CacheData>> newDataMap, Map<String, Collection<String>> evictionsByKey) {
        this.log.info(String.format("Caching %s IAM roles in %s for account %s", newDataMap.get(Keys.Namespace.IAM_ROLE.toString()).size(), this.getAgentType(), this.accountName));
        if (evictionsByKey.get(Keys.Namespace.IAM_ROLE.toString()).size() > 0) {
            this.log.info(String.format("Evicting %s IAM roles in %s for account %s", evictionsByKey.get(Keys.Namespace.IAM_ROLE.toString()).size(), this.getAgentType(), this.accountName));
        }
    }

    private Map<String, Collection<String>> computeEvictableData(Collection<CacheData> newData, Collection<String> oldKeys) {
        Set newKeys = newData.stream().map(CacheData::getId).collect(Collectors.toSet());
        HashSet<String> evictedKeys = new HashSet<String>();
        for (String oldKey : oldKeys) {
            if (newKeys.contains(oldKey)) continue;
            evictedKeys.add(oldKey);
        }
        HashMap<String, Collection<String>> evictionsByKey = new HashMap<String, Collection<String>>();
        evictionsByKey.put(Keys.Namespace.IAM_ROLE.toString(), evictedKeys);
        return evictionsByKey;
    }

    private Map<String, Collection<CacheData>> generateFreshData(Set<IamRole> cacheableRoles) {
        HashSet<DefaultCacheData> dataPoints = new HashSet<DefaultCacheData>();
        HashMap<String, Collection<CacheData>> newDataMap = new HashMap<String, Collection<CacheData>>();
        for (IamRole iamRole : cacheableRoles) {
            String key = Keys.getIamRoleKey(this.accountName, iamRole.getName());
            Map<String, Object> attributes = IamRoleCachingAgent.convertIamRoleToAttributes(iamRole);
            DefaultCacheData data = new DefaultCacheData(key, attributes, Collections.emptyMap());
            dataPoints.add(data);
        }
        newDataMap.put(Keys.Namespace.IAM_ROLE.toString(), dataPoints);
        return newDataMap;
    }

    private Set<IamRole> fetchIamRoles(AmazonIdentityManagement iam, String accountName) {
        ListRolesResult listRolesResult;
        HashSet<IamRole> cacheableRoles = new HashSet<IamRole>();
        String marker = null;
        do {
            ListRolesRequest request = new ListRolesRequest();
            if (marker != null) {
                request.setMarker(marker);
            }
            listRolesResult = iam.listRoles(request);
            List roles = listRolesResult.getRoles();
            for (Role role : roles) {
                cacheableRoles.add(new IamRole(role.getArn(), role.getRoleName(), accountName, this.getTrustedEntities(role.getAssumeRolePolicyDocument())));
            }
        } while ((marker = listRolesResult.isTruncated() != false ? listRolesResult.getMarker() : null) != null && marker.length() != 0);
        return cacheableRoles;
    }

    private boolean keyAccountFilter(String key) {
        Map<String, String> keyParts = Keys.parse(key);
        return keyParts != null && keyParts.get("account").equals(this.accountName);
    }

    private Set<IamTrustRelationship> getTrustedEntities(String urlEncodedPolicyDocument) {
        HashSet<IamTrustRelationship> trustedEntities = new HashSet<IamTrustRelationship>();
        String decodedPolicyDocument = URLDecoder.decode(urlEncodedPolicyDocument);
        try {
            Map policyDocument = (Map)this.objectMapper.readValue(decodedPolicyDocument, Map.class);
            List statementItems = (List)policyDocument.get("Statement");
            for (Map statementItem : statementItems) {
                if (!"sts:AssumeRole".equals(statementItem.get("Action"))) continue;
                Map principal = (Map)statementItem.get("Principal");
                for (Map.Entry principalEntry : principal.entrySet()) {
                    if (principalEntry.getValue() instanceof List) {
                        ((List)principalEntry.getValue()).stream().forEach(o -> trustedEntities.add(new IamTrustRelationship((String)principalEntry.getKey(), o.toString())));
                        continue;
                    }
                    trustedEntities.add(new IamTrustRelationship((String)principalEntry.getKey(), principalEntry.getValue().toString()));
                }
            }
        }
        catch (IOException e) {
            this.log.error("Unable to extract trusted entities (policyDocument: {})", (Object)urlEncodedPolicyDocument, (Object)e);
        }
        return trustedEntities;
    }

    private static Map<String, Object> convertIamRoleToAttributes(IamRole iamRole) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", iamRole.getName());
        attributes.put("accountName", iamRole.getAccountName());
        attributes.put("arn", iamRole.getId());
        attributes.put("trustRelationships", iamRole.getTrustRelationships());
        return attributes;
    }
}

