/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.EventSourceMappingConfiguration;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingResult;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.LambdaFunction;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.UpsertLambdaFunctionEventMappingDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import org.pf4j.util.StringUtils;

public class UpsertLambdaEventSourceAtomicOperation
extends AbstractLambdaAtomicOperation<UpsertLambdaFunctionEventMappingDescription, Object>
implements AtomicOperation<Object> {
    public UpsertLambdaEventSourceAtomicOperation(UpsertLambdaFunctionEventMappingDescription description) {
        super(description, "UPSERT_LAMBDA_FUNCTION_EVENT_MAPPING");
    }

    public Object operate(List priorOutputs) {
        String functionName = ((UpsertLambdaFunctionEventMappingDescription)this.description).getFunctionName();
        String region = ((UpsertLambdaFunctionEventMappingDescription)this.description).getRegion();
        String account = ((UpsertLambdaFunctionEventMappingDescription)this.description).getAccount();
        LambdaFunction cache = (LambdaFunction)this.lambdaFunctionProvider.getFunction(account, region, functionName);
        List<EventSourceMappingConfiguration> eventSourceMappingConfigurations = cache.getEventSourceMappings();
        for (EventSourceMappingConfiguration eventSourceMappingConfiguration : eventSourceMappingConfigurations) {
            if (!eventSourceMappingConfiguration.getEventSourceArn().equalsIgnoreCase(((UpsertLambdaFunctionEventMappingDescription)this.description).getEventSourceArn())) continue;
            ((UpsertLambdaFunctionEventMappingDescription)this.description).setProperty("uuid", eventSourceMappingConfiguration.getUUID());
            return this.updateEventSourceMappingResult(cache);
        }
        return this.createEventSourceMapping(cache);
    }

    private UpdateEventSourceMappingResult updateEventSourceMappingResult(LambdaFunction cache) {
        this.updateTaskStatus("Initializing Updating of AWS Lambda Function Event Mapping Operation...");
        AWSLambda client = this.getLambdaClient();
        UpdateEventSourceMappingRequest request = new UpdateEventSourceMappingRequest().withFunctionName(cache.getFunctionArn()).withBatchSize(((UpsertLambdaFunctionEventMappingDescription)this.description).getBatchsize()).withBisectBatchOnFunctionError(((UpsertLambdaFunctionEventMappingDescription)this.description).getBisectBatchOnError()).withMaximumBatchingWindowInSeconds(((UpsertLambdaFunctionEventMappingDescription)this.description).getMaxBatchingWindowSecs()).withMaximumRecordAgeInSeconds(((UpsertLambdaFunctionEventMappingDescription)this.description).getMaxRecordAgeSecs()).withMaximumRetryAttempts(((UpsertLambdaFunctionEventMappingDescription)this.description).getMaxRetryAttempts()).withParallelizationFactor(((UpsertLambdaFunctionEventMappingDescription)this.description).getParallelizationFactor()).withTumblingWindowInSeconds(((UpsertLambdaFunctionEventMappingDescription)this.description).getTumblingWindowSecs()).withDestinationConfig(((UpsertLambdaFunctionEventMappingDescription)this.description).getDestinationConfig()).withEnabled(((UpsertLambdaFunctionEventMappingDescription)this.description).getEnabled()).withUUID(((UpsertLambdaFunctionEventMappingDescription)this.description).getUuid());
        if (StringUtils.isNotNullOrEmpty((String)((UpsertLambdaFunctionEventMappingDescription)this.description).getQualifier())) {
            String fullArnWithQualifier = String.format("%s:%s", cache.getFunctionArn(), ((UpsertLambdaFunctionEventMappingDescription)this.description).getQualifier());
            request.setFunctionName(fullArnWithQualifier);
        }
        UpdateEventSourceMappingResult result = client.updateEventSourceMapping(request);
        this.updateTaskStatus("Finished Updating of AWS Lambda Function Event Mapping Operation...");
        return result;
    }

    private CreateEventSourceMappingResult createEventSourceMapping(LambdaFunction cache) {
        this.updateTaskStatus("Initializing Creation of AWS Lambda Function Event Source Mapping...");
        AWSLambda client = this.getLambdaClient();
        CreateEventSourceMappingRequest request = new CreateEventSourceMappingRequest().withFunctionName(cache.getFunctionArn()).withBatchSize(((UpsertLambdaFunctionEventMappingDescription)this.description).getBatchsize()).withBisectBatchOnFunctionError(((UpsertLambdaFunctionEventMappingDescription)this.description).getBisectBatchOnError()).withMaximumBatchingWindowInSeconds(((UpsertLambdaFunctionEventMappingDescription)this.description).getMaxBatchingWindowSecs()).withMaximumRecordAgeInSeconds(((UpsertLambdaFunctionEventMappingDescription)this.description).getMaxRecordAgeSecs()).withMaximumRetryAttempts(((UpsertLambdaFunctionEventMappingDescription)this.description).getMaxRetryAttempts()).withParallelizationFactor(((UpsertLambdaFunctionEventMappingDescription)this.description).getParallelizationFactor()).withTumblingWindowInSeconds(((UpsertLambdaFunctionEventMappingDescription)this.description).getTumblingWindowSecs()).withDestinationConfig(((UpsertLambdaFunctionEventMappingDescription)this.description).getDestinationConfig()).withEnabled(((UpsertLambdaFunctionEventMappingDescription)this.description).getEnabled()).withStartingPosition(((UpsertLambdaFunctionEventMappingDescription)this.description).getStartingPosition()).withEventSourceArn(((UpsertLambdaFunctionEventMappingDescription)this.description).getEventSourceArn());
        if (StringUtils.isNotNullOrEmpty((String)((UpsertLambdaFunctionEventMappingDescription)this.description).getQualifier())) {
            String fullArnWithQualifier = String.format("%s:%s", cache.getFunctionArn(), ((UpsertLambdaFunctionEventMappingDescription)this.description).getQualifier());
            request.setFunctionName(fullArnWithQualifier);
        }
        CreateEventSourceMappingResult result = client.createEventSourceMapping(request);
        this.updateTaskStatus("Finished Creation of AWS Lambda Function Event Mapping Operation...");
        return result;
    }
}

