/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.LambdaFunction;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.UpdateLambdaFunctionCodeDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class UpdateLambdaCodeAtomicOperation
extends AbstractLambdaAtomicOperation<UpdateLambdaFunctionCodeDescription, UpdateFunctionCodeResult>
implements AtomicOperation<UpdateFunctionCodeResult> {
    public UpdateLambdaCodeAtomicOperation(UpdateLambdaFunctionCodeDescription description) {
        super(description, "UPDATE_LAMBDA_FUNCTION_CODE");
    }

    public UpdateFunctionCodeResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Updating of AWS Lambda Function Code Operation...");
        return this.updateFunctionConfigurationResult();
    }

    private UpdateFunctionCodeResult updateFunctionConfigurationResult() {
        LambdaFunction lambdaFunction = (LambdaFunction)this.lambdaFunctionProvider.getFunction(((UpdateLambdaFunctionCodeDescription)this.description).getAccount(), ((UpdateLambdaFunctionCodeDescription)this.description).getRegion(), ((UpdateLambdaFunctionCodeDescription)this.description).getFunctionName());
        AWSLambda client = this.getLambdaClient();
        UpdateFunctionCodeRequest request = new UpdateFunctionCodeRequest().withFunctionName(lambdaFunction.getFunctionArn()).withPublish(((UpdateLambdaFunctionCodeDescription)this.description).getPublish()).withS3Bucket(((UpdateLambdaFunctionCodeDescription)this.description).getS3bucket()).withS3Key(((UpdateLambdaFunctionCodeDescription)this.description).getS3key());
        UpdateFunctionCodeResult result = client.updateFunctionCode(request);
        this.updateTaskStatus("Finished Updating of AWS Lambda Function Code Operation...");
        return result;
    }
}

