/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.PutProvisionedConcurrencyConfigRequest;
import com.amazonaws.services.lambda.model.PutProvisionedConcurrencyConfigResult;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.PutLambdaProvisionedConcurrencyDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class PutLambdaProvisionedConcurrencyAtomicOperation
extends AbstractLambdaAtomicOperation<PutLambdaProvisionedConcurrencyDescription, PutProvisionedConcurrencyConfigResult>
implements AtomicOperation<PutProvisionedConcurrencyConfigResult> {
    public PutLambdaProvisionedConcurrencyAtomicOperation(PutLambdaProvisionedConcurrencyDescription description) {
        super(description, "PUT_LAMBDA_FUNCTION_PROVISIONED_CONCURRENCY");
    }

    public PutProvisionedConcurrencyConfigResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Atomic Operation AWS Lambda for PutProvisionedConcurrency...");
        return this.putProvisionedFunctionConcurrency(((PutLambdaProvisionedConcurrencyDescription)this.description).getFunctionName(), ((PutLambdaProvisionedConcurrencyDescription)this.description).getQualifier(), ((PutLambdaProvisionedConcurrencyDescription)this.description).getProvisionedConcurrentExecutions());
    }

    private PutProvisionedConcurrencyConfigResult putProvisionedFunctionConcurrency(String functionName, String qualifier, int provisionedConcurrentExecutions) {
        AWSLambda client = this.getLambdaClient();
        PutProvisionedConcurrencyConfigRequest req = new PutProvisionedConcurrencyConfigRequest().withFunctionName(functionName).withQualifier(qualifier).withProvisionedConcurrentExecutions(Integer.valueOf(provisionedConcurrentExecutions));
        PutProvisionedConcurrencyConfigResult result = client.putProvisionedConcurrencyConfig(req);
        this.updateTaskStatus("Finished Atomic Operation AWS Lambda for PutProvisionedConcurrency...");
        return result;
    }
}

