/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest;
import com.amazonaws.services.lambda.model.DeleteProvisionedConcurrencyConfigResult;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.DeleteLambdaProvisionedConcurrencyDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class DeleteLambdaProvisionedConcurrencyAtomicOperation
extends AbstractLambdaAtomicOperation<DeleteLambdaProvisionedConcurrencyDescription, DeleteProvisionedConcurrencyConfigResult>
implements AtomicOperation<DeleteProvisionedConcurrencyConfigResult> {
    public DeleteLambdaProvisionedConcurrencyAtomicOperation(DeleteLambdaProvisionedConcurrencyDescription description) {
        super(description, "DELETE_LAMBDA_FUNCTION_PROVISIONED_CONCURRENCY");
    }

    public DeleteProvisionedConcurrencyConfigResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Atomic Operation AWS Lambda for DeleteProvisionedConcurrency...");
        return this.deleteProvisionedFunctionConcurrency(((DeleteLambdaProvisionedConcurrencyDescription)this.description).getFunctionName(), ((DeleteLambdaProvisionedConcurrencyDescription)this.description).getQualifier());
    }

    private DeleteProvisionedConcurrencyConfigResult deleteProvisionedFunctionConcurrency(String functionName, String qualifier) {
        AWSLambda client = this.getLambdaClient();
        DeleteProvisionedConcurrencyConfigRequest req = new DeleteProvisionedConcurrencyConfigRequest().withFunctionName(functionName).withQualifier(qualifier);
        DeleteProvisionedConcurrencyConfigResult result = client.deleteProvisionedConcurrencyConfig(req);
        this.updateTaskStatus("Finished Atomic Operation AWS Lambda for DeleteProvisionedConcurrency...");
        return result;
    }
}

