/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.reflection;

import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import java.util.Objects;
import java.util.Optional;

public class MethodResolver {
    private final TypeInfo callerType;
    private String expression;

    public MethodResolver(TypeInfo callerType, String expression) {
        this.callerType = callerType;
        this.expression = expression;
    }

    public MethodInvocation resolve() {
        TypeInfo ownerType;
        int lastDot = this.expression.lastIndexOf(46);
        if (lastDot >= 0) {
            ownerType = this.toClass(this.expression.substring(0, lastDot));
            this.expression = this.expression.substring(lastDot + 1);
        } else {
            ownerType = this.callerType;
        }
        MethodInvocation method = this.resolveEnclosing(ownerType, this.expression).orElseThrow(() -> new RuntimeException("no no-arg method '" + this.expression + "' found in " + String.valueOf(ownerType)));
        if (!method.isAccessibleFrom(this.callerType)) {
            throw new RuntimeException(this.callerType.getTypeName() + " can't access " + String.valueOf(method));
        }
        return method;
    }

    private Optional<MethodInvocation> resolveEnclosing(TypeInfo type, String expression) {
        return type.enclosingTypes().map(t -> t.getMethod(expression, new Class[0]).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    private TypeInfo toClass(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return TypeInfo.of(Class.forName(className, true, loader));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("class not found for expression '" + this.expression + "'", e);
        }
    }
}

