/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.json;

import io.smallrye.graphql.client.impl.typesafe.json.GraphQLClientValueHelper;
import io.smallrye.graphql.client.impl.typesafe.json.Location;
import io.smallrye.graphql.client.impl.typesafe.json.Reader;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import jakarta.json.JsonNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class JsonNumberReader
extends Reader<JsonNumber> {
    JsonNumberReader(TypeInfo type, Location location, JsonNumber value, FieldInfo field) {
        super(type, location, value, field);
    }

    @Override
    Object read() {
        try {
            return this.read(this.location, (JsonNumber)this.value, this.type.getRawType());
        }
        catch (ArithmeticException e) {
            throw GraphQLClientValueHelper.fail(this.location, this.value);
        }
    }

    private Object read(Location location, JsonNumber value, Class<?> rawType) {
        if (Byte.TYPE.equals(rawType) || Byte.class.equals(rawType)) {
            return (byte)this.readIntBetween(location, value, -128, 127);
        }
        if (Character.TYPE.equals(rawType) || Character.class.equals(rawType)) {
            return Character.valueOf((char)this.readIntBetween(location, value, 0, 65535));
        }
        if (Short.TYPE.equals(rawType) || Short.class.equals(rawType)) {
            return (short)this.readIntBetween(location, value, Short.MIN_VALUE, Short.MAX_VALUE);
        }
        if (Integer.TYPE.equals(rawType) || Integer.class.equals(rawType)) {
            return value.intValueExact();
        }
        if (Long.TYPE.equals(rawType) || Long.class.equals(rawType)) {
            return value.longValueExact();
        }
        if (Float.TYPE.equals(rawType) || Float.class.equals(rawType)) {
            return Float.valueOf((float)value.doubleValue());
        }
        if (Double.TYPE.equals(rawType) || Double.class.equals(rawType)) {
            return value.doubleValue();
        }
        if (BigInteger.class.equals(rawType)) {
            return value.bigIntegerValueExact();
        }
        if (BigDecimal.class.equals(rawType) || Object.class.equals(rawType)) {
            return value.bigDecimalValue();
        }
        if (OptionalInt.class.equals(rawType)) {
            return OptionalInt.of(value.intValueExact());
        }
        if (OptionalLong.class.equals(rawType)) {
            return OptionalLong.of(value.longValueExact());
        }
        if (OptionalDouble.class.equals(rawType)) {
            return OptionalDouble.of(value.doubleValue());
        }
        throw GraphQLClientValueHelper.fail(location, value);
    }

    private int readIntBetween(Location location, JsonNumber value, int minValue, int maxValue) {
        int intValue = value.intValueExact();
        GraphQLClientValueHelper.check(location, value, intValue >= minValue);
        GraphQLClientValueHelper.check(location, value, intValue <= maxValue);
        return intValue;
    }
}

