/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.functions.Function;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;

public class ContextPropagatorOnMaybeAssemblyAction
implements Function<Maybe, Maybe> {
    private ThreadContext threadContext;

    public ContextPropagatorOnMaybeAssemblyAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public Maybe apply(Maybe t) throws Exception {
        return new ContextPropagatorMaybe(t, this.threadContext.currentContextExecutor());
    }

    public static class ContextPropagatorMaybe<T>
    extends Maybe<T> {
        private final Maybe<T> source;
        private final Executor contextExecutor;

        public ContextPropagatorMaybe(Maybe<T> t, Executor contextExecutor) {
            this.source = t;
            this.contextExecutor = contextExecutor;
        }

        protected void subscribeActual(MaybeObserver<? super T> observer) {
            this.contextExecutor.execute(() -> this.source.subscribe(observer));
        }
    }
}

