/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.web.client;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate;
import io.vertx.mutiny.ext.web.client.predicate.ResponsePredicateResult;
import io.vertx.mutiny.ext.web.codec.BodyCodec;
import io.vertx.mutiny.ext.web.multipart.MultipartForm;
import java.util.function.Function;
import org.reactivestreams.Publisher;

@MutinyGen(value=io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T> {
    public static final TypeArg<HttpRequest> __TYPE_ARG = new TypeArg(obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest)obj), HttpRequest::getDelegate);
    private final io.vertx.ext.web.client.HttpRequest<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private MultiMap cached_0;

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    HttpRequest() {
        this.delegate = null;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public io.vertx.ext.web.client.HttpRequest getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpRequest<T> method(HttpMethod value) {
        this.delegate.method(value);
        return this;
    }

    public HttpRequest<T> rawMethod(String method) {
        this.delegate.rawMethod(method);
        return this;
    }

    public HttpRequest<T> port(int value) {
        this.delegate.port(value);
        return this;
    }

    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        HttpRequest ret = HttpRequest.newInstance(this.delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> host(String value) {
        this.delegate.host(value);
        return this;
    }

    public HttpRequest<T> virtualHost(String value) {
        this.delegate.virtualHost(value);
        return this;
    }

    public HttpRequest<T> uri(String value) {
        this.delegate.uri(value);
        return this;
    }

    public HttpRequest<T> putHeaders(MultiMap headers) {
        this.delegate.putHeaders(headers.getDelegate());
        return this;
    }

    public HttpRequest<T> putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance((io.vertx.core.MultiMap)this.delegate.headers());
        return ret;
    }

    public HttpRequest<T> basicAuthentication(String id, String password) {
        this.delegate.basicAuthentication(id, password);
        return this;
    }

    public HttpRequest<T> basicAuthentication(Buffer id, Buffer password) {
        this.delegate.basicAuthentication(id.getDelegate(), password.getDelegate());
        return this;
    }

    public HttpRequest<T> bearerTokenAuthentication(String bearerToken) {
        this.delegate.bearerTokenAuthentication(bearerToken);
        return this;
    }

    public HttpRequest<T> ssl(Boolean value) {
        this.delegate.ssl(value);
        return this;
    }

    public HttpRequest<T> timeout(long value) {
        this.delegate.timeout(value);
        return this;
    }

    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.delegate.addQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.delegate.setQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> followRedirects(boolean value) {
        this.delegate.followRedirects(value);
        return this;
    }

    public HttpRequest<T> expect(final Function<HttpResponse<Void>, ResponsePredicateResult> predicate) {
        this.delegate.expect((Function)new Function<io.vertx.ext.web.client.HttpResponse<Void>, io.vertx.ext.web.client.predicate.ResponsePredicateResult>(){

            @Override
            public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<Void> arg) {
                ResponsePredicateResult ret = (ResponsePredicateResult)predicate.apply(HttpResponse.newInstance(arg, TypeArg.unknown()));
                return ret.getDelegate();
            }
        });
        return this;
    }

    public HttpRequest<T> expect(ResponsePredicate predicate) {
        this.delegate.expect(predicate.getDelegate());
        return this;
    }

    public MultiMap queryParams() {
        MultiMap ret = MultiMap.newInstance((io.vertx.core.MultiMap)this.delegate.queryParams());
        return ret;
    }

    public HttpRequest<T> copy() {
        HttpRequest<T> ret = HttpRequest.newInstance(this.delegate.copy(), this.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> multipartMixed(boolean allow) {
        HttpRequest<T> ret = HttpRequest.newInstance(this.delegate.multipartMixed(allow), this.__typeArg_0);
        return ret;
    }

    private void __sendStream(ReadStream<Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> sendStream(ReadStream<Buffer> body) {
        return AsyncResultUni.toUni(handler -> this.__sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendStreamAndAwait(ReadStream<Buffer> body) {
        return (HttpResponse)this.sendStream(body).await().indefinitely();
    }

    private void __sendStream(Publisher<Buffer> body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendStream(ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> sendStream(Publisher<Buffer> body) {
        return AsyncResultUni.toUni(handler -> this.__sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendStreamAndAwait(Publisher<Buffer> body) {
        return (HttpResponse)this.sendStream(body).await().indefinitely();
    }

    private void __sendBuffer(Buffer body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendBuffer(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> sendBuffer(Buffer body) {
        return AsyncResultUni.toUni(handler -> this.__sendBuffer(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendBufferAndAwait(Buffer body) {
        return (HttpResponse)this.sendBuffer(body).await().indefinitely();
    }

    private void __sendJsonObject(JsonObject body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJsonObject(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> sendJsonObject(JsonObject body) {
        return AsyncResultUni.toUni(handler -> this.__sendJsonObject(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendJsonObjectAndAwait(JsonObject body) {
        return (HttpResponse)this.sendJsonObject(body).await().indefinitely();
    }

    private void __sendJson(Object body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendJson(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> sendJson(Object body) {
        return AsyncResultUni.toUni(handler -> this.__sendJson(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendJsonAndAwait(Object body) {
        return (HttpResponse)this.sendJson(body).await().indefinitely();
    }

    private void __sendForm(MultiMap body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendForm(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> sendForm(MultiMap body) {
        return AsyncResultUni.toUni(handler -> this.__sendForm(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendFormAndAwait(MultiMap body) {
        return (HttpResponse)this.sendForm(body).await().indefinitely();
    }

    private void __sendMultipartForm(MultipartForm body, final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.sendMultipartForm(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> sendMultipartForm(MultipartForm body) {
        return AsyncResultUni.toUni(handler -> this.__sendMultipartForm(body, (Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendMultipartFormAndAwait(MultipartForm body) {
        return (HttpResponse)this.sendMultipartForm(body).await().indefinitely();
    }

    private void __send(final Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.delegate.send(new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>(){

            public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)ar.result(), HttpRequest.this.__typeArg_0)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<HttpResponse<T>> send() {
        return AsyncResultUni.toUni(handler -> this.__send((Handler<AsyncResult<HttpResponse<T>>>)handler));
    }

    public HttpResponse<T> sendAndAwait() {
        return (HttpResponse)this.send().await().indefinitely();
    }

    public HttpRequest<T> putHeader(String name, Iterable<String> value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
        return arg != null ? new HttpRequest<T>(arg) : null;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
    }
}

