package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.time.OffsetTime;
import java.time.LocalDateTime;
import java.util.UUID;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.core.json.JsonArray;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.time.LocalDate;
import java.time.LocalTime;
import io.vertx.core.json.JsonObject;
import java.time.temporal.Temporal;

/**
 * A single row of the {@link io.vertx.mutiny.sqlclient.RowSet execution result rowset}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Row original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.Row.class)
public class Row extends io.vertx.mutiny.sqlclient.Tuple implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Row> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Row((io.vertx.sqlclient.Row) obj),
    Row::getDelegate
  );

  private final io.vertx.sqlclient.Row delegate;
  
  public Row(io.vertx.sqlclient.Row delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Row(Object delegate) {
    super((io.vertx.sqlclient.Row)delegate);
    this.delegate = (io.vertx.sqlclient.Row)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Row() {
    super(null);
    this.delegate = null;
  }

  @Override
  public io.vertx.sqlclient.Row getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Row that = (Row) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param pos the column position
   * @return the column name or <code>null</code>
   */
  public String getColumnName(int pos) { 
    String ret = delegate.getColumnName(pos);
    return ret;
  }

  /**
   * @param column the column name
   * @return the column name or <code>-1</code> if not found
   */
  public int getColumnIndex(String column) { 
    int ret = delegate.getColumnIndex(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object getValue(String column) { 
    java.lang.Object ret = (Object) delegate.getValue(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Boolean getBoolean(String column) { 
    Boolean ret = delegate.getBoolean(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Short getShort(String column) { 
    Short ret = delegate.getShort(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Integer getInteger(String column) { 
    Integer ret = delegate.getInteger(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Long getLong(String column) { 
    Long ret = delegate.getLong(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Float getFloat(String column) { 
    Float ret = delegate.getFloat(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Double getDouble(String column) { 
    Double ret = delegate.getDouble(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public String getString(String column) { 
    String ret = delegate.getString(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object getJson(String column) { 
    java.lang.Object ret = (Object) delegate.getJson(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public JsonObject getJsonObject(String column) { 
    JsonObject ret = delegate.getJsonObject(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public JsonArray getJsonArray(String column) { 
    JsonArray ret = delegate.getJsonArray(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.mutiny.core.buffer.Buffer getBuffer(String column) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(column));
    return ret;
  }

  /**
   * @param type 
   * @param column 
   * @return 
   */
  public <T> T get(java.lang.Class<T> type, String column) { 
    T ret = (T)io.smallrye.mutiny.vertx.TypeArg.of(type).wrap(delegate.get(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type), column));
    return ret;
  }

  /**
   * @return the json representation
   */
  public JsonObject toJson() { 
    JsonObject ret = delegate.toJson();
    return ret;
  }

  /**
   */
  public void release() { 
    delegate.release();
  }

  /**
   * @param column the column
   * @return the <code>column</code> value
   */
  public io.vertx.sqlclient.data.Numeric getNumeric(String column) { 
    io.vertx.sqlclient.data.Numeric ret = delegate.getNumeric(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.temporal.Temporal getTemporal(String column) { 
    java.time.temporal.Temporal ret = delegate.getTemporal(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDate getLocalDate(String column) { 
    java.time.LocalDate ret = delegate.getLocalDate(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalTime getLocalTime(String column) { 
    java.time.LocalTime ret = delegate.getLocalTime(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDateTime getLocalDateTime(String column) { 
    java.time.LocalDateTime ret = delegate.getLocalDateTime(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetTime getOffsetTime(String column) { 
    java.time.OffsetTime ret = delegate.getOffsetTime(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetDateTime getOffsetDateTime(String column) { 
    java.time.OffsetDateTime ret = delegate.getOffsetDateTime(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.util.UUID getUUID(String column) { 
    java.util.UUID ret = delegate.getUUID(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.math.BigDecimal getBigDecimal(String column) { 
    java.math.BigDecimal ret = delegate.getBigDecimal(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Boolean[] getArrayOfBooleans(String column) { 
    java.lang.Boolean[] ret = delegate.getArrayOfBooleans(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Short[] getArrayOfShorts(String column) { 
    java.lang.Short[] ret = delegate.getArrayOfShorts(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Integer[] getArrayOfIntegers(String column) { 
    java.lang.Integer[] ret = delegate.getArrayOfIntegers(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Long[] getArrayOfLongs(String column) { 
    java.lang.Long[] ret = delegate.getArrayOfLongs(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Float[] getArrayOfFloats(String column) { 
    java.lang.Float[] ret = delegate.getArrayOfFloats(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Double[] getArrayOfDoubles(String column) { 
    java.lang.Double[] ret = delegate.getArrayOfDoubles(column);
    return ret;
  }

  /**
   * @param column the column
   * @return the <code>column</code> value
   */
  public io.vertx.sqlclient.data.Numeric[] getArrayOfNumerics(String column) { 
    io.vertx.sqlclient.data.Numeric[] ret = delegate.getArrayOfNumerics(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.String[] getArrayOfStrings(String column) { 
    java.lang.String[] ret = delegate.getArrayOfStrings(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.core.json.JsonObject[] getArrayOfJsonObjects(String column) { 
    io.vertx.core.json.JsonObject[] ret = delegate.getArrayOfJsonObjects(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.core.json.JsonArray[] getArrayOfJsonArrays(String column) { 
    io.vertx.core.json.JsonArray[] ret = delegate.getArrayOfJsonArrays(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.temporal.Temporal[] getArrayOfTemporals(String column) { 
    java.time.temporal.Temporal[] ret = delegate.getArrayOfTemporals(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDate[] getArrayOfLocalDates(String column) { 
    java.time.LocalDate[] ret = delegate.getArrayOfLocalDates(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalTime[] getArrayOfLocalTimes(String column) { 
    java.time.LocalTime[] ret = delegate.getArrayOfLocalTimes(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDateTime[] getArrayOfLocalDateTimes(String column) { 
    java.time.LocalDateTime[] ret = delegate.getArrayOfLocalDateTimes(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetTime[] getArrayOfOffsetTimes(String column) { 
    java.time.OffsetTime[] ret = delegate.getArrayOfOffsetTimes(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetDateTime[] getArrayOfOffsetDateTimes(String column) { 
    java.time.OffsetDateTime[] ret = delegate.getArrayOfOffsetDateTimes(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.util.UUID[] getArrayOfUUIDs(String column) { 
    java.util.UUID[] ret = delegate.getArrayOfUUIDs(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.math.BigDecimal[] getArrayOfBigDecimals(String column) { 
    java.math.BigDecimal[] ret = delegate.getArrayOfBigDecimals(column);
    return ret;
  }

  /**
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object[] getArrayOfJsons(String column) { 
    java.lang.Object[] ret = delegate.getArrayOfJsons(column);
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final Object JSON_NULL = (Object) io.vertx.sqlclient.Row.JSON_NULL;
  public static  Row newInstance(io.vertx.sqlclient.Row arg) {
    return arg != null ? new Row(arg) : null;
  }

}
