/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import mutiny.zero.internal.MapOperator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public interface PublisherHelpers {
    public static <T> CompletionStage<List<T>> collectToList(Publisher<T> publisher) {
        final ArrayList list = new ArrayList();
        final CompletableFuture<List<T>> future = new CompletableFuture<List<T>>();
        publisher.subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            public void onNext(T t) {
                list.add(t);
            }

            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            public void onComplete() {
                future.complete(list);
            }
        });
        return future;
    }

    public static <I, O> Publisher<O> map(Publisher<I> source, Function<I, O> mapper) {
        Objects.requireNonNull(source, "The source cannot be null");
        Objects.requireNonNull(mapper, "The mapper cannot be null");
        return new MapOperator<I, O>(source, mapper);
    }
}

