/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mutiny.zero.internal.AlreadyCompletedSubscription;
import mutiny.zero.internal.IteratorSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class StreamPublisher<T>
implements Publisher<T> {
    private final Supplier<Stream<T>> supplier;

    public StreamPublisher(Supplier<Stream<T>> supplier) {
        this.supplier = supplier;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Stream<T> stream = this.supplier.get();
        if (stream == null) {
            subscriber.onSubscribe((Subscription)new AlreadyCompletedSubscription());
            subscriber.onError((Throwable)new NullPointerException("The supplied stream cannot be null"));
        } else {
            subscriber.onSubscribe(new IteratorSubscription<T>(stream.iterator(), subscriber));
        }
    }
}

