/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import mutiny.zero.internal.BufferingTubeBase;
import org.reactivestreams.Subscriber;

public class BufferingTube<T>
extends BufferingTubeBase<T> {
    private final LinkedBlockingDeque<T> overflowQueue;

    public BufferingTube(Subscriber<? super T> subscriber, int bufferSize) {
        super(subscriber, bufferSize);
        this.overflowQueue = new LinkedBlockingDeque(bufferSize);
    }

    @Override
    Queue<T> overflowQueue() {
        return this.overflowQueue;
    }

    @Override
    protected void handleItem(T item) {
        if (this.outstandingRequests() > 0L) {
            this.dispatchQueue.offer(item);
            this.drainLoop();
        } else if (!this.overflowQueue.offer(item)) {
            this.fail(new IllegalStateException("The following item cannot be propagated because there is no demand and the overflow buffer is full: " + item));
        }
    }
}

