/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ArgumentRule {
    DEFAULT{

        @Override
        void checkArguments(List<String> arguments) throws IllegalArgumentException {
        }

        @Override
        List<String> formatArguments(Path command, List<String> arguments) throws IllegalArgumentException {
            return Stream.concat(Stream.of(command.toString()), arguments.stream()).toList();
        }
    }
    ,
    BATCH{

        @Override
        void checkArguments(List<String> arguments) throws IllegalArgumentException {
            for (String argument : arguments) {
                int cp;
                int len = argument.length();
                for (int i = 0; i < len; i += Character.charCount(cp)) {
                    cp = argument.codePointAt(i);
                    switch (cp) {
                        case 33: 
                        case 38: 
                        case 39: 
                        case 43: 
                        case 44: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 91: 
                        case 93: 
                        case 94: 
                        case 96: 
                        case 123: 
                        case 125: 
                        case 126: {
                            throw this.invalidCharacter(argument, i);
                        }
                    }
                    if (!Character.isWhitespace(cp) && !Character.isISOControl(cp)) continue;
                    throw this.invalidCharacter(argument, i);
                }
            }
        }

        @Override
        List<String> formatArguments(Path command, List<String> arguments) throws IllegalArgumentException {
            return Stream.concat(Stream.of(command.toString()), arguments.stream()).toList();
        }
    }
    ,
    POWERSHELL{

        @Override
        void checkArguments(List<String> arguments) throws IllegalArgumentException {
        }

        @Override
        List<String> formatArguments(Path command, List<String> arguments) throws IllegalArgumentException {
            return Stream.concat(Stream.of("powershell.exe", "-ExecutionPolicy", "Bypass", "-File", command.toString()), arguments.stream()).toList();
        }
    };


    IllegalArgumentException invalidCharacter(String argument, int idx) {
        return new IllegalArgumentException("Argument \"%s\" has an invalid character at index %d for argument rule %s".formatted(new Object[]{argument, idx, this}));
    }

    abstract void checkArguments(List<String> var1) throws IllegalArgumentException;

    abstract List<String> formatArguments(Path var1, List<String> var2) throws IllegalArgumentException;
}

