/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.process.LineReader;
import io.smallrye.common.process.ProcessUtil;
import io.smallrye.common.process.WaitableProcessHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntPredicate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PipelineBuilder<O> {
    public PipelineBuilder<O> arguments(List<String> var1);

    public PipelineBuilder<O> arguments(String ... var1);

    public PipelineBuilder<O> directory(Path var1);

    public PipelineBuilder<O> environment(Map<String, String> var1);

    public PipelineBuilder<O> modifyEnvironment(Consumer<Map<String, String>> var1);

    public Output<O> output();

    public Error<O> error();

    public O run();

    public CompletableFuture<O> runAsync();

    public PipelineBuilder<O> exitCodeChecker(IntPredicate var1);

    public PipelineBuilder<O> whileRunning(Consumer<WaitableProcessHandle> var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Error<O>
    extends PipelineBuilder<O> {
        public Error<O> discard();

        public Error<O> inherited();

        public Error<O> charset(Charset var1);

        default public Error<O> nativeCharset() {
            return this.charset(ProcessUtil.nativeCharset());
        }

        public Error<O> logOnSuccess(boolean var1);

        public Error<O> gatherOnFail(boolean var1);

        public Error<O> maxCaptureLineLength(int var1);

        public Error<O> captureHeadLines(int var1);

        public Error<O> captureTailLines(int var1);

        default public Error<O> transferTo(OutputStream stream) {
            Assert.checkNotNullParam((String)"stream", (Object)stream);
            return this.consumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> is.transferTo(stream)));
        }

        default public Error<O> copyAndTransferTo(OutputStream stream) {
            Assert.checkNotNullParam((String)"stream", (Object)stream);
            return this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> is.transferTo(stream)));
        }

        default public Error<O> transferTo(Writer writer) {
            Assert.checkNotNullParam((String)"writer", (Object)writer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> br.transferTo(writer)));
        }

        default public Error<O> copyAndTransferTo(Writer writer) {
            Assert.checkNotNullParam((String)"writer", (Object)writer);
            return this.copyAndConsumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> br.transferTo(writer)));
        }

        public Error<O> transferTo(Path var1);

        default public Error<O> copyAndTransferTo(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            return this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> {
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    is.transferTo(os);
                }
            }));
        }

        public Error<O> appendTo(Path var1);

        default public Error<O> copyAndAppendTo(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            return this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> {
                try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                    is.transferTo(os);
                }
            }));
        }

        public Error<O> consumeBytesWith(ExceptionConsumer<InputStream, IOException> var1);

        public Error<O> copyAndConsumeBytesWith(ExceptionConsumer<InputStream, IOException> var1);

        public Error<O> consumeWith(ExceptionConsumer<BufferedReader, IOException> var1);

        public Error<O> copyAndConsumeWith(ExceptionConsumer<BufferedReader, IOException> var1);

        default public Error<O> consumeLinesWith(int maxLineLength, ExceptionConsumer<String, IOException> consumer) {
            Assert.checkMinimumParameter((String)"maxLineLength", (int)1, (int)maxLineLength);
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                String line;
                LineReader lr = new LineReader((Reader)br, maxLineLength);
                while ((line = lr.readLine()) != null) {
                    consumer.accept((Object)line);
                }
            }));
        }

        default public Error<O> copyAndConsumeLinesWith(int maxLineLength, ExceptionConsumer<String, IOException> consumer) {
            Assert.checkMinimumParameter((String)"maxLineLength", (int)1, (int)maxLineLength);
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.copyAndConsumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                String line;
                LineReader lr = new LineReader((Reader)br, maxLineLength);
                while ((line = lr.readLine()) != null) {
                    consumer.accept((Object)line);
                }
            }));
        }

        public Error<O> redirect();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Output<O>
    extends PipelineBuilder<O> {
        public Output<Void> discard();

        public Output<Void> inherited();

        public Output<O> charset(Charset var1);

        default public Output<O> nativeCharset() {
            return this.charset(ProcessUtil.nativeCharset());
        }

        public Output<String> toSingleString(int var1);

        public Output<List<String>> toStringList(int var1, int var2);

        public Output<O> gatherOnFail(boolean var1);

        public Output<O> maxCaptureLineLength(int var1);

        public Output<O> captureHeadLines(int var1);

        public Output<O> captureTailLines(int var1);

        default public Output<Void> transferTo(OutputStream stream) {
            Assert.checkNotNullParam((String)"stream", (Object)stream);
            return this.consumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> is.transferTo(stream)));
        }

        default public Output<O> copyAndTransferTo(OutputStream stream) {
            Assert.checkNotNullParam((String)"stream", (Object)stream);
            return this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> is.transferTo(stream)));
        }

        default public Output<Void> transferTo(Writer writer) {
            Assert.checkNotNullParam((String)"writer", (Object)writer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> br.transferTo(writer)));
        }

        default public Output<O> copyAndTransferTo(Writer writer) {
            Assert.checkNotNullParam((String)"writer", (Object)writer);
            return this.copyAndConsumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)is -> is.transferTo(writer)));
        }

        public Output<Void> transferTo(Path var1);

        default public Output<O> copyAndTransferTo(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            return this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> {
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    is.transferTo(os);
                }
            }));
        }

        public Output<Void> appendTo(Path var1);

        default public Output<O> copyAndAppendTo(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            return this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> {
                try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                    is.transferTo(os);
                }
            }));
        }

        default public Output<Void> consumeBytesWith(ExceptionConsumer<InputStream, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.processBytesWith(is -> {
                consumer.accept(is);
                return null;
            });
        }

        public Output<O> copyAndConsumeBytesWith(ExceptionConsumer<InputStream, IOException> var1);

        default public Output<Void> consumeWith(ExceptionConsumer<BufferedReader, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.processWith(rd -> {
                consumer.accept(rd);
                return null;
            });
        }

        public Output<O> copyAndConsumeWith(ExceptionConsumer<BufferedReader, IOException> var1);

        default public Output<Void> consumeLinesWith(int maxLineLength, ExceptionConsumer<String, IOException> consumer) {
            Assert.checkMinimumParameter((String)"maxLineLength", (int)1, (int)maxLineLength);
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                String line;
                LineReader lr = new LineReader((Reader)br, maxLineLength);
                while ((line = lr.readLine()) != null) {
                    consumer.accept((Object)line);
                }
            }));
        }

        default public Output<O> copyAndConsumeLinesWith(int maxLineLength, ExceptionConsumer<String, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.copyAndConsumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                String line;
                LineReader lr = new LineReader((Reader)br, maxLineLength);
                while ((line = lr.readLine()) != null) {
                    consumer.accept((Object)line);
                }
            }));
        }

        public <O2> Output<O2> processBytesWith(ExceptionFunction<InputStream, O2, IOException> var1);

        public <O2> Output<O2> processWith(ExceptionFunction<BufferedReader, O2, IOException> var1);

        public PipelineBuilder<Void> pipeTo(Path var1);

        default public PipelineBuilder<Void> pipeTo(Path command, List<String> args) {
            return this.pipeTo(command).arguments(args);
        }

        default public PipelineBuilder<Void> pipeTo(Path command, String ... args) {
            return this.pipeTo(command).arguments(args);
        }
    }
}

