/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.CustomSamplingContext;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.SentryLevel;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.exception.InvalidSentryTraceHeaderException;
import io.sentry.spring.tracing.TransactionNameProvider;
import io.sentry.util.Objects;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentryTracingFilter
extends OncePerRequestFilter {
    private static final String TRANSACTION_OP = "http.server";
    @NotNull
    private final TransactionNameProvider transactionNameProvider;
    @NotNull
    private final IHub hub;

    public SentryTracingFilter() {
        this((IHub)HubAdapter.getInstance());
    }

    public SentryTracingFilter(@NotNull IHub hub, @NotNull TransactionNameProvider transactionNameProvider) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.transactionNameProvider = (TransactionNameProvider)Objects.requireNonNull((Object)transactionNameProvider, (String)"transactionNameProvider is required");
    }

    public SentryTracingFilter(@NotNull IHub hub) {
        this(hub, new TransactionNameProvider());
    }

    protected void doFilterInternal(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse, @NotNull FilterChain filterChain) throws ServletException, IOException {
        if (this.hub.isEnabled()) {
            String sentryTraceHeader = httpRequest.getHeader("sentry-trace");
            ITransaction transaction = this.startTransaction(httpRequest, sentryTraceHeader);
            try {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (Throwable e) {
                transaction.setStatus(SpanStatus.INTERNAL_ERROR);
                throw e;
            }
            finally {
                String transactionName = this.transactionNameProvider.provideTransactionName(httpRequest);
                if (transactionName != null) {
                    transaction.setName(transactionName);
                    transaction.setOperation(TRANSACTION_OP);
                    if (transaction.getStatus() == null) {
                        transaction.setStatus(SpanStatus.fromHttpStatusCode((int)httpResponse.getStatus()));
                    }
                    transaction.finish();
                }
            }
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private ITransaction startTransaction(@NotNull HttpServletRequest request, @Nullable String sentryTraceHeader) {
        String name = request.getMethod() + " " + request.getRequestURI();
        CustomSamplingContext customSamplingContext = new CustomSamplingContext();
        customSamplingContext.set("request", (Object)request);
        if (sentryTraceHeader != null) {
            try {
                TransactionContext contexts = TransactionContext.fromSentryTrace((String)name, (String)TRANSACTION_OP, (SentryTraceHeader)new SentryTraceHeader(sentryTraceHeader));
                return this.hub.startTransaction(contexts, customSamplingContext, true);
            }
            catch (InvalidSentryTraceHeaderException e) {
                this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, (Throwable)e, "Failed to parse Sentry trace header: %s", new Object[]{e.getMessage()});
            }
        }
        return this.hub.startTransaction(name, TRANSACTION_OP, customSamplingContext, true);
    }
}

