/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot.graphql;

import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.graphql.SentryGraphqlInstrumentation;
import io.sentry.graphql.SentryInstrumentation;
import io.sentry.graphql.SentrySubscriptionHandler;
import io.sentry.spring.boot.SentryProperties;
import io.sentry.spring.graphql.SentryDataFetcherExceptionResolverAdapter;
import io.sentry.spring.graphql.SentryGraphqlBeanPostProcessor;
import io.sentry.spring.graphql.SentrySpringSubscriptionHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
public class SentryGraphqlAutoConfiguration {
    @Bean(name={"sentryInstrumentation"})
    @ConditionalOnMissingBean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public SentryInstrumentation sentryInstrumentationWebMvc(@NotNull SentryProperties sentryProperties, @NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring5GrahQLWebMVC");
        return this.createInstrumentation(sentryProperties, beforeSpanCallback, false);
    }

    @Bean(name={"sentryInstrumentation"})
    @ConditionalOnMissingBean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public SentryInstrumentation sentryInstrumentationWebflux(@NotNull SentryProperties sentryProperties, @NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring5GrahQLWebFlux");
        return this.createInstrumentation(sentryProperties, beforeSpanCallback, true);
    }

    private SentryInstrumentation createInstrumentation(@NotNull SentryProperties sentryProperties, @NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback, boolean captureRequestBody) {
        return new SentryInstrumentation((SentryGraphqlInstrumentation.BeforeSpanCallback)beforeSpanCallback.getIfAvailable(), (SentrySubscriptionHandler)new SentrySpringSubscriptionHandler(), captureRequestBody, sentryProperties.getGraphql().getIgnoredErrorTypes());
    }

    @Bean
    @Order(value=-2147483648)
    public SentryDataFetcherExceptionResolverAdapter exceptionResolverAdapter() {
        return new SentryDataFetcherExceptionResolverAdapter();
    }

    @Bean
    public static SentryGraphqlBeanPostProcessor graphqlBeanPostProcessor() {
        return new SentryGraphqlBeanPostProcessor();
    }
}

