/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.transport;

import io.sentry.core.ISerializer;
import io.sentry.core.SentryEnvelope;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.transport.CurrentDateProvider;
import io.sentry.core.transport.IConnectionConfigurator;
import io.sentry.core.transport.ICurrentDateProvider;
import io.sentry.core.transport.ITransport;
import io.sentry.core.transport.TransportResult;
import io.sentry.core.util.Objects;
import io.sentry.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
@ApiStatus.Internal
public class HttpTransport
implements ITransport {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @Nullable
    private final Proxy proxy;
    @NotNull
    private final IConnectionConfigurator connectionConfigurator;
    @NotNull
    private final ISerializer serializer;
    private final int connectionTimeout;
    private final int readTimeout;
    private final boolean bypassSecurity;
    @NotNull
    private final URL storeUrl;
    @NotNull
    private final URL envelopeUrl;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Map<DataCategory, Date> sentryRetryAfterLimit = new ConcurrentHashMap<DataCategory, Date>();
    private static final int HTTP_RETRY_AFTER_DEFAULT_DELAY_MILLIS = 60000;
    @NotNull
    private final ICurrentDateProvider currentDateProvider;

    public HttpTransport(@NotNull SentryOptions options, @NotNull IConnectionConfigurator connectionConfigurator, int connectionTimeoutMillis, int readTimeoutMillis, boolean bypassSecurity, @NotNull URL sentryUrl) {
        this(options, connectionConfigurator, connectionTimeoutMillis, readTimeoutMillis, bypassSecurity, sentryUrl, CurrentDateProvider.getInstance());
    }

    HttpTransport(@NotNull SentryOptions options, @NotNull IConnectionConfigurator connectionConfigurator, int connectionTimeoutMillis, int readTimeoutMillis, boolean bypassSecurity, @NotNull URL sentryUrl, @NotNull ICurrentDateProvider currentDateProvider) {
        this.proxy = options.getProxy();
        this.connectionConfigurator = connectionConfigurator;
        this.serializer = options.getSerializer();
        this.connectionTimeout = connectionTimeoutMillis;
        this.readTimeout = readTimeoutMillis;
        this.options = options;
        this.bypassSecurity = bypassSecurity;
        this.currentDateProvider = Objects.requireNonNull(currentDateProvider, "CurrentDateProvider is required.");
        try {
            URI uri = sentryUrl.toURI();
            this.storeUrl = uri.resolve(uri.getPath() + "/store/").toURL();
            this.envelopeUrl = uri.resolve(uri.getPath() + "/envelope/").toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Failed to compose the Sentry's server URL.", e);
        }
    }

    @NotNull
    protected HttpURLConnection open(@Nullable Proxy proxy) throws IOException {
        return this.open(this.storeUrl, proxy);
    }

    @NotNull
    protected HttpURLConnection open(@NotNull URL url, @Nullable Proxy proxy) throws IOException {
        return (HttpURLConnection)(proxy == null ? url.openConnection() : url.openConnection(proxy));
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public TransportResult send(@NotNull SentryEvent event) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isRetryAfter(@NotNull String itemType) {
        DataCategory dataCategory = this.getCategoryFromItemType(itemType);
        Date currentDate = new Date(this.currentDateProvider.getCurrentTimeMillis());
        Date dateAllCategories = this.sentryRetryAfterLimit.get((Object)DataCategory.All);
        if (dateAllCategories != null && !currentDate.after(dateAllCategories)) {
            return true;
        }
        if (DataCategory.Unknown.equals((Object)dataCategory)) {
            return false;
        }
        Date dateCategory = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (dateCategory != null) {
            return !currentDate.after(dateCategory);
        }
        return false;
    }

    @NotNull
    private DataCategory getCategoryFromItemType(@NotNull String itemType) {
        switch (itemType) {
            case "event": {
                return DataCategory.Error;
            }
            case "session": {
                return DataCategory.Session;
            }
            case "attachment": {
                return DataCategory.Attachment;
            }
            case "transaction": {
                return DataCategory.Transaction;
            }
        }
        return DataCategory.Unknown;
    }

    @NotNull
    private HttpURLConnection createConnection(boolean asEnvelope) throws IOException {
        HttpURLConnection connection;
        String contentType = "application/json";
        if (asEnvelope) {
            connection = this.open(this.envelopeUrl, this.proxy);
            contentType = "application/x-sentry-envelope";
        } else {
            connection = this.open(this.proxy);
        }
        this.connectionConfigurator.configure(connection);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Encoding", "UTF-8");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Connection", "close");
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setReadTimeout(this.readTimeout);
        if (this.bypassSecurity && connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setHostnameVerifier((__, ___) -> true);
        }
        connection.connect();
        return connection;
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public TransportResult send(@NotNull SentryEnvelope envelope) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateRetryAfterLimits(@NotNull HttpURLConnection connection, int responseCode) {
        String retryAfterHeader = connection.getHeaderField("Retry-After");
        String sentryRateLimitHeader = connection.getHeaderField("X-Sentry-Rate-Limits");
        this.updateRetryAfterLimits(sentryRateLimitHeader, retryAfterHeader, responseCode);
    }

    private void updateRetryAfterLimits(@Nullable String sentryRateLimitHeader, @Nullable String retryAfterHeader, int errorCode) {
        if (sentryRateLimitHeader != null) {
            for (String limit : sentryRateLimitHeader.split(",", -1)) {
                String[] retryAfterAndCategories = (limit = limit.replace(" ", "")).split(":", -1);
                if (retryAfterAndCategories.length <= 0) continue;
                String retryAfter = retryAfterAndCategories[0];
                long retryAfterMillis = this.parseRetryAfterOrDefault(retryAfter);
                if (retryAfterAndCategories.length <= 1) continue;
                String allCategories = retryAfterAndCategories[1];
                Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
                if (allCategories != null && !allCategories.isEmpty()) {
                    String[] categories;
                    for (String catItem : categories = allCategories.split(";", -1)) {
                        DataCategory dataCategory = DataCategory.Unknown;
                        try {
                            dataCategory = DataCategory.valueOf(StringUtils.capitalize(catItem));
                        }
                        catch (IllegalArgumentException e) {
                            this.options.getLogger().log(SentryLevel.INFO, e, "Unknown category: %s", catItem);
                        }
                        if (DataCategory.Unknown.equals((Object)dataCategory)) continue;
                        this.applyRetryAfterOnlyIfLonger(dataCategory, date);
                    }
                    continue;
                }
                this.applyRetryAfterOnlyIfLonger(DataCategory.All, date);
            }
        } else if (errorCode == 429) {
            long retryAfterMillis = this.parseRetryAfterOrDefault(retryAfterHeader);
            Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
            this.applyRetryAfterOnlyIfLonger(DataCategory.All, date);
        }
    }

    private void applyRetryAfterOnlyIfLonger(@NotNull DataCategory dataCategory, @NotNull Date date) {
        Date oldDate = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (oldDate == null || date.after(oldDate)) {
            this.sentryRetryAfterLimit.put(dataCategory, date);
        }
    }

    private long parseRetryAfterOrDefault(@Nullable String retryAfterHeader) {
        long retryAfterMillis = 60000L;
        if (retryAfterHeader != null) {
            try {
                retryAfterMillis = (long)(Double.parseDouble(retryAfterHeader) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retryAfterMillis;
    }

    private void logErrorInPayload(@NotNull HttpURLConnection connection) {
        if (this.options.isDebug()) {
            String errorMessage = null;
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                errorMessage = this.getErrorMessageFromStream(errorStream);
            }
            if (null == errorMessage || errorMessage.isEmpty()) {
                errorMessage = "An exception occurred while submitting the event to the Sentry server.";
            }
            this.options.getLogger().log(SentryLevel.DEBUG, errorMessage, new Object[0]);
        }
    }

    private String getErrorMessageFromStream(@NotNull InputStream errorStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(line);
                first = false;
            }
        }
        catch (Exception e2) {
            this.options.getLogger().log(SentryLevel.ERROR, "Exception while reading the error message from the connection: " + e2.getMessage(), new Object[0]);
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static enum DataCategory {
        All("__all__"),
        Default("default"),
        Error("error"),
        Session("session"),
        Attachment("attachment"),
        Transaction("transaction"),
        Security("security"),
        Unknown("unknown");

        private final String category;

        private DataCategory(String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

