/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.timber;

import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryLogLevel;
import io.sentry.SentryOptions;
import io.sentry.android.timber.SentryTimberTree;
import io.sentry.util.IntegrationUtils;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/sentry/android/timber/SentryTimberIntegration;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "minEventLevel", "Lio/sentry/SentryLevel;", "minBreadcrumbLevel", "minLogsLevel", "Lio/sentry/SentryLogLevel;", "(Lio/sentry/SentryLevel;Lio/sentry/SentryLevel;Lio/sentry/SentryLogLevel;)V", "logger", "Lio/sentry/ILogger;", "getMinBreadcrumbLevel", "()Lio/sentry/SentryLevel;", "getMinEventLevel", "getMinLogsLevel", "()Lio/sentry/SentryLogLevel;", "tree", "Lio/sentry/android/timber/SentryTimberTree;", "close", "", "register", "scopes", "Lio/sentry/IScopes;", "options", "Lio/sentry/SentryOptions;", "Companion", "sentry-android-timber_release"})
public final class SentryTimberIntegration
implements Integration,
Closeable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryLevel minEventLevel;
    @NotNull
    private final SentryLevel minBreadcrumbLevel;
    @NotNull
    private final SentryLogLevel minLogsLevel;
    private SentryTimberTree tree;
    private ILogger logger;

    public SentryTimberIntegration(@NotNull SentryLevel minEventLevel, @NotNull SentryLevel minBreadcrumbLevel, @NotNull SentryLogLevel minLogsLevel) {
        Intrinsics.checkNotNullParameter((Object)minEventLevel, (String)"minEventLevel");
        Intrinsics.checkNotNullParameter((Object)minBreadcrumbLevel, (String)"minBreadcrumbLevel");
        Intrinsics.checkNotNullParameter((Object)minLogsLevel, (String)"minLogsLevel");
        this.minEventLevel = minEventLevel;
        this.minBreadcrumbLevel = minBreadcrumbLevel;
        this.minLogsLevel = minLogsLevel;
    }

    public /* synthetic */ SentryTimberIntegration(SentryLevel sentryLevel, SentryLevel sentryLevel2, SentryLogLevel sentryLogLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sentryLevel = SentryLevel.ERROR;
        }
        if ((n & 2) != 0) {
            sentryLevel2 = SentryLevel.INFO;
        }
        if ((n & 4) != 0) {
            sentryLogLevel = SentryLogLevel.INFO;
        }
        this(sentryLevel, sentryLevel2, sentryLogLevel);
    }

    @NotNull
    public final SentryLevel getMinEventLevel() {
        return this.minEventLevel;
    }

    @NotNull
    public final SentryLevel getMinBreadcrumbLevel() {
        return this.minBreadcrumbLevel;
    }

    @NotNull
    public final SentryLogLevel getMinLogsLevel() {
        return this.minLogsLevel;
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ILogger iLogger = options.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)iLogger, (String)"getLogger(...)");
        this.logger = iLogger;
        this.tree = new SentryTimberTree(scopes, this.minEventLevel, this.minBreadcrumbLevel, this.minLogsLevel);
        SentryTimberTree sentryTimberTree = this.tree;
        if (sentryTimberTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
            sentryTimberTree = null;
        }
        Timber.plant((Timber.Tree)sentryTimberTree);
        ILogger iLogger2 = this.logger;
        if (iLogger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            iLogger2 = null;
        }
        iLogger2.log(SentryLevel.DEBUG, "SentryTimberIntegration installed.", new Object[0]);
        IntegrationUtils.addIntegrationToSdkVersion((String)"Timber");
    }

    @Override
    public void close() {
        if (this.tree != null) {
            SentryTimberTree sentryTimberTree = this.tree;
            if (sentryTimberTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
                sentryTimberTree = null;
            }
            Timber.uproot((Timber.Tree)sentryTimberTree);
            if (this.logger != null) {
                ILogger iLogger = this.logger;
                if (iLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    iLogger = null;
                }
                iLogger.log(SentryLevel.DEBUG, "SentryTimberIntegration removed.", new Object[0]);
            }
        }
    }

    public SentryTimberIntegration() {
        this(null, null, null, 7, null);
    }

    static {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-timber", "8.22.0");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/sentry/android/timber/SentryTimberIntegration$Companion;", "", "()V", "sentry-android-timber_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

