/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.sqlite;

import android.database.SQLException;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SpanStatus;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r\u00a2\u0006\u0002\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sentry/android/sqlite/SQLiteSpanManager;", "", "hub", "Lio/sentry/IHub;", "databaseName", "", "(Lio/sentry/IHub;Ljava/lang/String;)V", "stackTraceFactory", "Lio/sentry/SentryStackTraceFactory;", "performSql", "T", "sql", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "sentry-android-sqlite_release"})
public final class SQLiteSpanManager {
    @NotNull
    private final IHub hub;
    @Nullable
    private final String databaseName;
    @NotNull
    private final SentryStackTraceFactory stackTraceFactory;

    public SQLiteSpanManager(@NotNull IHub hub, @Nullable String databaseName) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.databaseName = databaseName;
        this.stackTraceFactory = new SentryStackTraceFactory(this.hub.getOptions());
        SentryIntegrationPackageStorage.getInstance().addIntegration("SQLite");
    }

    public /* synthetic */ SQLiteSpanManager(IHub iHub, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(iHub, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T performSql(@NotNull String sql, @NotNull Function0<? extends T> operation) throws SQLException {
        Object object;
        ISpan span;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        ISpan iSpan = this.hub.getSpan();
        ISpan iSpan2 = span = iSpan != null ? iSpan.startChild("db.sql.query", sql) : null;
        Object object2 = iSpan2 != null ? iSpan2.getSpanContext() : null;
        if (object2 != null) {
            object2.setOrigin("auto.db.sqlite");
        }
        try {
            Object result = operation.invoke();
            ISpan iSpan3 = span;
            if (iSpan3 != null) {
                iSpan3.setStatus(SpanStatus.OK);
            }
            object = result;
        }
        catch (Throwable e) {
            ISpan iSpan4 = span;
            if (iSpan4 != null) {
                iSpan4.setStatus(SpanStatus.INTERNAL_ERROR);
            }
            ISpan iSpan5 = span;
            if (iSpan5 != null) {
                iSpan5.setThrowable(e);
            }
            throw e;
        }
        finally {
            ISpan iSpan6 = span;
            if (iSpan6 != null) {
                ISpan iSpan7;
                ISpan $this$performSql_u24lambda_u240 = iSpan7 = iSpan6;
                boolean bl = false;
                boolean isMainThread = this.hub.getOptions().getMainThreadChecker().isMainThread();
                $this$performSql_u24lambda_u240.setData("blocked_main_thread", (Object)isMainThread);
                if (isMainThread) {
                    $this$performSql_u24lambda_u240.setData("call_stack", (Object)this.stackTraceFactory.getInAppCallStack());
                }
                if (this.databaseName != null) {
                    $this$performSql_u24lambda_u240.setData("db.system", (Object)"sqlite");
                    $this$performSql_u24lambda_u240.setData("db.name", (Object)this.databaseName);
                } else {
                    $this$performSql_u24lambda_u240.setData("db.system", (Object)"in-memory");
                }
                $this$performSql_u24lambda_u240.finish();
            }
        }
        return (T)object;
    }

    public SQLiteSpanManager() {
        this(null, null, 3, null);
    }
}

