/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.sqlite;

import android.database.SQLException;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SpanStatus;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/sentry/android/sqlite/SQLiteSpanManager;", "", "hub", "Lio/sentry/IHub;", "(Lio/sentry/IHub;)V", "stackTraceFactory", "Lio/sentry/SentryStackTraceFactory;", "performSql", "T", "sql", "", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "sentry-android-sqlite_release"})
public final class SQLiteSpanManager {
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryStackTraceFactory stackTraceFactory;

    public SQLiteSpanManager(@NotNull IHub hub) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.stackTraceFactory = new SentryStackTraceFactory(this.hub.getOptions());
        SentryIntegrationPackageStorage.getInstance().addIntegration("SQLite");
    }

    public /* synthetic */ SQLiteSpanManager(IHub iHub, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        this(iHub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T performSql(@NotNull String sql, @NotNull Function0<? extends T> operation) throws SQLException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        ISpan iSpan = this.hub.getSpan();
        ISpan span = iSpan != null ? iSpan.startChild("db.sql.query", sql) : null;
        try {
            Object result = operation.invoke();
            ISpan iSpan2 = span;
            if (iSpan2 != null) {
                iSpan2.setStatus(SpanStatus.OK);
            }
            object = result;
        }
        catch (Throwable e) {
            ISpan iSpan3 = span;
            if (iSpan3 != null) {
                iSpan3.setStatus(SpanStatus.INTERNAL_ERROR);
            }
            ISpan iSpan4 = span;
            if (iSpan4 != null) {
                iSpan4.setThrowable(e);
            }
            throw e;
        }
        finally {
            ISpan iSpan5 = span;
            if (iSpan5 != null) {
                ISpan iSpan6;
                ISpan $this$performSql_u24lambda_u240 = iSpan6 = iSpan5;
                boolean bl = false;
                boolean isMainThread = this.hub.getOptions().getMainThreadChecker().isMainThread();
                $this$performSql_u24lambda_u240.setData("blocked_main_thread", (Object)isMainThread);
                if (isMainThread) {
                    $this$performSql_u24lambda_u240.setData("call_stack", (Object)this.stackTraceFactory.getInAppCallStack());
                }
                $this$performSql_u24lambda_u240.finish();
            }
        }
        return (T)object;
    }

    public SQLiteSpanManager() {
        this(null, 1, null);
    }
}

