/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.android.core.internal.util.Debouncer;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import io.sentry.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SystemEventsBreadcrumbsIntegration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    @TestOnly
    @Nullable
    SystemEventsBroadcastReceiver receiver;
    @Nullable
    private SentryAndroidOptions options;
    @NotNull
    private final String[] actions;
    private boolean isClosed = false;
    @NotNull
    private final AutoClosableReentrantLock startLock = new AutoClosableReentrantLock();

    public SystemEventsBreadcrumbsIntegration(@NotNull Context context) {
        this(context, SystemEventsBreadcrumbsIntegration.getDefaultActionsInternal());
    }

    private SystemEventsBreadcrumbsIntegration(@NotNull Context context, @NotNull String[] actions) {
        this.context = ContextUtils.getApplicationContext(context);
        this.actions = actions;
    }

    public SystemEventsBreadcrumbsIntegration(@NotNull Context context, @NotNull List<String> actions) {
        this.context = ContextUtils.getApplicationContext(context);
        this.actions = new String[actions.size()];
        actions.toArray(this.actions);
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "SystemEventsBreadcrumbsIntegration enabled: %s", new Object[]{this.options.isEnableSystemEventBreadcrumbs()});
        if (this.options.isEnableSystemEventBreadcrumbs()) {
            try {
                options.getExecutorService().submit(() -> {
                    try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
                        if (!this.isClosed) {
                            this.startSystemEventsReceiver(scopes, (SentryAndroidOptions)options);
                        }
                    }
                });
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.DEBUG, "Failed to start SystemEventsBreadcrumbsIntegration on executor thread.", e);
            }
        }
    }

    private void startSystemEventsReceiver(@NotNull IScopes scopes, @NotNull SentryAndroidOptions options) {
        this.receiver = new SystemEventsBroadcastReceiver(scopes, options);
        IntentFilter filter = new IntentFilter();
        for (String item : this.actions) {
            filter.addAction(item);
        }
        try {
            ContextUtils.registerReceiver(this.context, options, (BroadcastReceiver)this.receiver, filter);
            options.getLogger().log(SentryLevel.DEBUG, "SystemEventsBreadcrumbsIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion((String)"SystemEventsBreadcrumbs");
        }
        catch (Throwable e) {
            options.setEnableSystemEventBreadcrumbs(false);
            options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SystemEventsBreadcrumbsIntegration.", e);
        }
    }

    @NotNull
    public static List<String> getDefaultActions() {
        return Arrays.asList(SystemEventsBreadcrumbsIntegration.getDefaultActionsInternal());
    }

    @NotNull
    private static String[] getDefaultActionsInternal() {
        String[] actions = new String[]{"android.intent.action.ACTION_SHUTDOWN", "android.intent.action.AIRPLANE_MODE", "android.intent.action.BATTERY_CHANGED", "android.intent.action.CAMERA_BUTTON", "android.intent.action.CONFIGURATION_CHANGED", "android.intent.action.DATE_CHANGED", "android.intent.action.DEVICE_STORAGE_LOW", "android.intent.action.DEVICE_STORAGE_OK", "android.intent.action.DOCK_EVENT", "android.intent.action.DREAMING_STARTED", "android.intent.action.DREAMING_STOPPED", "android.intent.action.INPUT_METHOD_CHANGED", "android.intent.action.LOCALE_CHANGED", "android.intent.action.SCREEN_OFF", "android.intent.action.SCREEN_ON", "android.intent.action.TIMEZONE_CHANGED", "android.intent.action.TIME_SET", "android.os.action.DEVICE_IDLE_MODE_CHANGED", "android.os.action.POWER_SAVE_MODE_CHANGED"};
        return actions;
    }

    @Override
    public void close() throws IOException {
        try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
            this.isClosed = true;
        }
        if (this.receiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
            this.receiver = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "SystemEventsBreadcrumbsIntegration remove.", new Object[0]);
            }
        }
    }

    static final class SystemEventsBroadcastReceiver
    extends BroadcastReceiver {
        private static final long DEBOUNCE_WAIT_TIME_MS = 60000L;
        @NotNull
        private final IScopes scopes;
        @NotNull
        private final SentryAndroidOptions options;
        @NotNull
        private final Debouncer batteryChangedDebouncer = new Debouncer(AndroidCurrentDateProvider.getInstance(), 60000L, 0);
        private final char[] buf = new char[64];

        SystemEventsBroadcastReceiver(@NotNull IScopes scopes, @NotNull SentryAndroidOptions options) {
            this.scopes = scopes;
            this.options = options;
        }

        public void onReceive(Context context, @NotNull Intent intent) {
            @Nullable String action = intent.getAction();
            boolean isBatteryChanged = "android.intent.action.BATTERY_CHANGED".equals(action);
            if (isBatteryChanged && this.batteryChangedDebouncer.checkForDebounce()) {
                return;
            }
            long now = System.currentTimeMillis();
            try {
                this.options.getExecutorService().submit(() -> {
                    Breadcrumb breadcrumb = this.createBreadcrumb(now, intent, action, isBatteryChanged);
                    Hint hint = new Hint();
                    hint.set("android:intent", (Object)intent);
                    this.scopes.addBreadcrumb(breadcrumb, hint);
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @TestOnly
        @Nullable
        String getStringAfterDotFast(@Nullable String str) {
            if (str == null) {
                return null;
            }
            int len = str.length();
            int bufIndex = this.buf.length;
            for (int i = len - 1; i >= 0; --i) {
                char c = str.charAt(i);
                if (c == '.') {
                    return new String(this.buf, bufIndex, this.buf.length - bufIndex);
                }
                if (bufIndex == 0) {
                    return StringUtils.getStringAfterDot((String)str);
                }
                this.buf[--bufIndex] = c;
            }
            return str;
        }

        @NotNull
        private Breadcrumb createBreadcrumb(long timeMs, @NotNull Intent intent, @Nullable String action, boolean isBatteryChanged) {
            Breadcrumb breadcrumb = new Breadcrumb(timeMs);
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            String shortAction = this.getStringAfterDotFast(action);
            if (shortAction != null) {
                breadcrumb.setData("action", (Object)shortAction);
            }
            if (isBatteryChanged) {
                Boolean isCharging;
                Float batteryLevel = DeviceInfoUtil.getBatteryLevel(intent, this.options);
                if (batteryLevel != null) {
                    breadcrumb.setData("level", (Object)batteryLevel);
                }
                if ((isCharging = DeviceInfoUtil.isCharging(intent, this.options)) != null) {
                    breadcrumb.setData("charging", (Object)isCharging);
                }
            } else {
                Bundle extras = intent.getExtras();
                HashMap<String, String> newExtras = new HashMap<String, String>();
                if (extras != null && !extras.isEmpty()) {
                    for (String item : extras.keySet()) {
                        try {
                            Object value = extras.get(item);
                            if (value == null) continue;
                            newExtras.put(item, value.toString());
                        }
                        catch (Throwable exception) {
                            this.options.getLogger().log(SentryLevel.ERROR, exception, "%s key of the %s action threw an error.", new Object[]{item, action});
                        }
                    }
                    breadcrumb.setData("extras", newExtras);
                }
            }
            breadcrumb.setLevel(SentryLevel.INFO);
            return breadcrumb;
        }
    }
}

