/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ApplicationExitInfo;
import android.content.Context;
import io.sentry.Attachment;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ApplicationExitInfoHistoryDispatcher;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.cache.AndroidEnvelopeCache;
import io.sentry.android.core.internal.threaddump.Lines;
import io.sentry.android.core.internal.threaddump.ThreadDumpParser;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.hints.BlockingFlushHint;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.Message;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryThread;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.HintUtils;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressLint(value={"NewApi"})
public class AnrV2Integration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @Nullable
    private SentryAndroidOptions options;

    public AnrV2Integration(@NotNull Context context) {
        this(context, CurrentDateProvider.getInstance());
    }

    AnrV2Integration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider) {
        this.context = ContextUtils.getApplicationContext(context);
        this.dateProvider = dateProvider;
    }

    @SuppressLint(value={"NewApi"})
    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration enabled: %s", new Object[]{this.options.isAnrEnabled()});
        if (this.options.getCacheDirPath() == null) {
            this.options.getLogger().log(SentryLevel.INFO, "Cache dir is not set, unable to process ANRs", new Object[0]);
            return;
        }
        if (this.options.isAnrEnabled()) {
            try {
                options.getExecutorService().submit((Runnable)new ApplicationExitInfoHistoryDispatcher(this.context, scopes, this.options, this.dateProvider, new AnrV2Policy(this.options)));
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.DEBUG, "Failed to start ANR processor.", e);
            }
            options.getLogger().log(SentryLevel.DEBUG, "AnrV2Integration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion((String)"AnrV2");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "AnrV2Integration removed.", new Object[0]);
        }
    }

    private static final class AnrV2Policy
    implements ApplicationExitInfoHistoryDispatcher.ApplicationExitInfoPolicy {
        @NotNull
        private final SentryAndroidOptions options;

        AnrV2Policy(@NotNull SentryAndroidOptions options) {
            this.options = options;
        }

        @Override
        @NotNull
        public String getLabel() {
            return "ANR";
        }

        @Override
        public int getTargetReason() {
            return 6;
        }

        @Override
        public boolean shouldReportHistorical() {
            return this.options.isReportHistoricalAnrs();
        }

        @Override
        @Nullable
        public Long getLastReportedTimestamp() {
            return AndroidEnvelopeCache.lastReportedAnr(this.options);
        }

        @Override
        @Nullable
        public ApplicationExitInfoHistoryDispatcher.Report buildReport(@NotNull ApplicationExitInfo exitInfo, boolean shouldEnrich) {
            long anrTimestamp = exitInfo.getTimestamp();
            boolean isBackground = exitInfo.getImportance() != 100;
            ParseResult result = this.parseThreadDump(exitInfo, isBackground);
            if (result.type == ParseResult.Type.NO_DUMP) {
                this.options.getLogger().log(SentryLevel.WARNING, "Not reporting ANR event as there was no thread dump for the ANR %s", new Object[]{exitInfo.toString()});
                return null;
            }
            AnrV2Hint anrHint = new AnrV2Hint(this.options.getFlushTimeoutMillis(), this.options.getLogger(), anrTimestamp, shouldEnrich, isBackground);
            Hint hint = HintUtils.createWithTypeCheckHint((Object)((Object)anrHint));
            SentryEvent event = new SentryEvent();
            if (result.type == ParseResult.Type.ERROR) {
                Message sentryMessage = new Message();
                sentryMessage.setFormatted("Sentry Android SDK failed to parse system thread dump for this ANR. We recommend enabling [SentryOptions.isAttachAnrThreadDump] option to attach the thread dump as plain text and report this issue on GitHub.");
                event.setMessage(sentryMessage);
            } else if (result.type == ParseResult.Type.DUMP) {
                event.setThreads(result.threads);
                if (result.debugImages != null) {
                    DebugMeta debugMeta = new DebugMeta();
                    debugMeta.setImages(result.debugImages);
                    event.setDebugMeta(debugMeta);
                }
            }
            event.setLevel(SentryLevel.FATAL);
            event.setTimestamp(DateUtils.getDateTime((long)anrTimestamp));
            if (this.options.isAttachAnrThreadDump() && result.dump != null) {
                hint.setThreadDump(Attachment.fromThreadDump((byte[])result.dump));
            }
            return new ApplicationExitInfoHistoryDispatcher.Report(event, hint, anrHint);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private ParseResult parseThreadDump(@NotNull ApplicationExitInfo exitInfo, boolean isBackground) {
            byte[] dump;
            try (InputStream trace = exitInfo.getTraceInputStream();){
                if (trace == null) {
                    ParseResult parseResult = new ParseResult(ParseResult.Type.NO_DUMP);
                    return parseResult;
                }
                dump = this.getDumpBytes(trace);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to read ANR thread dump", e);
                return new ParseResult(ParseResult.Type.NO_DUMP);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(dump)));){
                Lines lines = Lines.readLines(reader);
                ThreadDumpParser threadDumpParser = new ThreadDumpParser(this.options, isBackground);
                threadDumpParser.parse(lines);
                @NotNull List<SentryThread> threads = threadDumpParser.getThreads();
                @NotNull List<DebugImage> debugImages = threadDumpParser.getDebugImages();
                if (threads.isEmpty()) {
                    ParseResult parseResult = new ParseResult(ParseResult.Type.NO_DUMP);
                    return parseResult;
                }
                ParseResult parseResult = new ParseResult(ParseResult.Type.DUMP, dump, threads, debugImages);
                return parseResult;
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to parse ANR thread dump", e);
                return new ParseResult(ParseResult.Type.ERROR, dump);
            }
        }

        private byte[] getDumpBytes(@NotNull InputStream trace) throws IOException {
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[1024];
                while ((nRead = trace.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                byte[] byArray = buffer.toByteArray();
                return byArray;
            }
        }
    }

    static final class ParseResult {
        final Type type;
        final byte[] dump;
        @Nullable
        final List<SentryThread> threads;
        @Nullable
        final List<DebugImage> debugImages;

        ParseResult(@NotNull Type type) {
            this.type = type;
            this.dump = null;
            this.threads = null;
            this.debugImages = null;
        }

        ParseResult(@NotNull Type type, byte[] dump) {
            this.type = type;
            this.dump = dump;
            this.threads = null;
            this.debugImages = null;
        }

        ParseResult(@NotNull Type type, byte[] dump, @Nullable List<SentryThread> threads, @Nullable List<DebugImage> debugImages) {
            this.type = type;
            this.dump = dump;
            this.threads = threads;
            this.debugImages = debugImages;
        }

        static enum Type {
            DUMP,
            NO_DUMP,
            ERROR;

        }
    }

    @ApiStatus.Internal
    public static final class AnrV2Hint
    extends BlockingFlushHint
    implements Backfillable,
    AbnormalExit {
        private final long timestamp;
        private final boolean shouldEnrich;
        private final boolean isBackgroundAnr;

        public AnrV2Hint(long flushTimeoutMillis, @NotNull ILogger logger, long timestamp, boolean shouldEnrich, boolean isBackgroundAnr) {
            super(flushTimeoutMillis, logger);
            this.timestamp = timestamp;
            this.shouldEnrich = shouldEnrich;
            this.isBackgroundAnr = isBackgroundAnr;
        }

        public boolean ignoreCurrentThread() {
            return false;
        }

        @NotNull
        public Long timestamp() {
            return this.timestamp;
        }

        public boolean shouldEnrich() {
            return this.shouldEnrich;
        }

        public String mechanism() {
            return this.isBackgroundAnr ? "anr_background" : "anr_foreground";
        }

        public boolean isFlushable(@Nullable SentryId eventId) {
            return true;
        }

        public void setFlushable(@NotNull SentryId eventId) {
        }
    }
}

