/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.Build;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BuildInfoProvider {
    @NotNull
    final ILogger logger;

    public BuildInfoProvider(@NotNull ILogger logger) {
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"The ILogger object is required.");
    }

    public int getSdkInfoVersion() {
        return Build.VERSION.SDK_INT;
    }

    @Nullable
    public String getBuildTags() {
        return Build.TAGS;
    }

    @Nullable
    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    @Nullable
    public String getModel() {
        return Build.MODEL;
    }

    @Nullable
    public String getVersionRelease() {
        return Build.VERSION.RELEASE;
    }

    @Nullable
    public Boolean isEmulator() {
        try {
            return Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.HARDWARE.contains("goldfish") || Build.HARDWARE.contains("ranchu") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.PRODUCT.contains("sdk_google") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("sdk_x86") || Build.PRODUCT.contains("vbox86p") || Build.PRODUCT.contains("emulator") || Build.PRODUCT.contains("simulator");
        }
        catch (Throwable e) {
            this.logger.log(SentryLevel.ERROR, "Error checking whether application is running in an emulator.", e);
            return null;
        }
    }
}

