/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.util;

import android.content.Context;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AndroidLazyEvaluator<T> {
    @Nullable
    private volatile T value = null;
    @NotNull
    private final AndroidEvaluator<T> evaluator;

    public AndroidLazyEvaluator(@NotNull AndroidEvaluator<T> evaluator) {
        this.evaluator = evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getValue(@NotNull Context context) {
        if (this.value == null) {
            AndroidLazyEvaluator androidLazyEvaluator = this;
            synchronized (androidLazyEvaluator) {
                if (this.value == null) {
                    this.value = this.evaluator.evaluate(context);
                }
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(@Nullable T value) {
        AndroidLazyEvaluator androidLazyEvaluator = this;
        synchronized (androidLazyEvaluator) {
            this.value = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetValue() {
        AndroidLazyEvaluator androidLazyEvaluator = this;
        synchronized (androidLazyEvaluator) {
            this.value = null;
        }
    }

    public static interface AndroidEvaluator<T> {
        @Nullable
        public T evaluate(@NotNull Context var1);
    }
}

