/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.content.Context;
import io.sentry.Hint;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryFeedbackOptions;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.CurrentActivityHolder;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.NdkHandlerStrategy;
import io.sentry.android.core.NoOpDebugImagesLoader;
import io.sentry.android.core.SentryUserFeedbackDialog;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryId;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SentryAndroidOptions
extends SentryOptions {
    private boolean anrEnabled = true;
    private long anrTimeoutIntervalMillis = 5000L;
    private boolean anrReportInDebug = false;
    private boolean enableActivityLifecycleBreadcrumbs = true;
    private boolean enableAppLifecycleBreadcrumbs = true;
    private boolean enableSystemEventBreadcrumbs = true;
    private boolean enableAppComponentBreadcrumbs = true;
    private boolean enableNetworkEventBreadcrumbs = true;
    private boolean enableAutoActivityLifecycleTracing = true;
    private boolean enableActivityLifecycleTracingAutoFinish = true;
    @NotNull
    private IDebugImagesLoader debugImagesLoader = NoOpDebugImagesLoader.getInstance();
    private boolean attachScreenshot;
    private boolean attachViewHierarchy;
    private boolean collectAdditionalContext = true;
    private long startupCrashFlushTimeoutMillis = 5000L;
    private final long startupCrashDurationThresholdMillis = 2000L;
    private boolean enableFramesTracking = true;
    @Nullable
    private String nativeSdkName = null;
    private boolean enableRootCheck = true;
    @Nullable
    private BeforeCaptureCallback beforeScreenshotCaptureCallback;
    @Nullable
    private BeforeCaptureCallback beforeViewHierarchyCaptureCallback;
    private boolean enableNdk = true;
    @NotNull
    private NdkHandlerStrategy ndkHandlerStrategy = NdkHandlerStrategy.SENTRY_HANDLER_STRATEGY_DEFAULT;
    private boolean enableScopeSync = true;
    private boolean enableAutoTraceIdGeneration = true;
    private boolean enableSystemEventBreadcrumbsExtras = false;
    private boolean reportHistoricalAnrs = false;
    private boolean attachAnrThreadDump = false;
    private boolean enablePerformanceV2 = true;
    @Nullable
    private SentryFrameMetricsCollector frameMetricsCollector;

    public SentryAndroidOptions() {
        this.setSentryClientName("sentry.java.android/8.24.0-alpha.1");
        this.setSdkVersion(this.createSdkVersion());
        this.setAttachServerName(false);
    }

    @NotNull
    private SdkVersion createSdkVersion() {
        SdkVersion sdkVersion = this.getSdkVersion();
        String name = "sentry.java.android";
        String version = "8.24.0-alpha.1";
        sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.android", (String)"8.24.0-alpha.1");
        sdkVersion.addPackage("maven:io.sentry:sentry-android-core", "8.24.0-alpha.1");
        return sdkVersion;
    }

    public boolean isAnrEnabled() {
        return this.anrEnabled;
    }

    public void setAnrEnabled(boolean anrEnabled) {
        this.anrEnabled = anrEnabled;
    }

    public long getAnrTimeoutIntervalMillis() {
        return this.anrTimeoutIntervalMillis;
    }

    public void setAnrTimeoutIntervalMillis(long anrTimeoutIntervalMillis) {
        this.anrTimeoutIntervalMillis = anrTimeoutIntervalMillis;
    }

    public boolean isAnrReportInDebug() {
        return this.anrReportInDebug;
    }

    public void setAnrReportInDebug(boolean anrReportInDebug) {
        this.anrReportInDebug = anrReportInDebug;
    }

    public boolean isEnableActivityLifecycleBreadcrumbs() {
        return this.enableActivityLifecycleBreadcrumbs;
    }

    public void setEnableActivityLifecycleBreadcrumbs(boolean enableActivityLifecycleBreadcrumbs) {
        this.enableActivityLifecycleBreadcrumbs = enableActivityLifecycleBreadcrumbs;
    }

    public boolean isEnableAppLifecycleBreadcrumbs() {
        return this.enableAppLifecycleBreadcrumbs;
    }

    public void setEnableAppLifecycleBreadcrumbs(boolean enableAppLifecycleBreadcrumbs) {
        this.enableAppLifecycleBreadcrumbs = enableAppLifecycleBreadcrumbs;
    }

    public boolean isEnableSystemEventBreadcrumbs() {
        return this.enableSystemEventBreadcrumbs;
    }

    public void setEnableSystemEventBreadcrumbs(boolean enableSystemEventBreadcrumbs) {
        this.enableSystemEventBreadcrumbs = enableSystemEventBreadcrumbs;
    }

    public boolean isEnableAppComponentBreadcrumbs() {
        return this.enableAppComponentBreadcrumbs;
    }

    public void setEnableAppComponentBreadcrumbs(boolean enableAppComponentBreadcrumbs) {
        this.enableAppComponentBreadcrumbs = enableAppComponentBreadcrumbs;
    }

    public boolean isEnableNetworkEventBreadcrumbs() {
        return this.enableNetworkEventBreadcrumbs;
    }

    public void setEnableNetworkEventBreadcrumbs(boolean enableNetworkEventBreadcrumbs) {
        this.enableNetworkEventBreadcrumbs = enableNetworkEventBreadcrumbs;
    }

    public void enableAllAutoBreadcrumbs(boolean enable) {
        this.enableActivityLifecycleBreadcrumbs = enable;
        this.enableAppComponentBreadcrumbs = enable;
        this.enableSystemEventBreadcrumbs = enable;
        this.enableAppLifecycleBreadcrumbs = enable;
        this.enableNetworkEventBreadcrumbs = enable;
        this.setEnableUserInteractionBreadcrumbs(enable);
    }

    @NotNull
    public IDebugImagesLoader getDebugImagesLoader() {
        return this.debugImagesLoader;
    }

    public void setDebugImagesLoader(@NotNull IDebugImagesLoader debugImagesLoader) {
        this.debugImagesLoader = debugImagesLoader != null ? debugImagesLoader : NoOpDebugImagesLoader.getInstance();
    }

    public boolean isEnableAutoActivityLifecycleTracing() {
        return this.enableAutoActivityLifecycleTracing;
    }

    public void setEnableAutoActivityLifecycleTracing(boolean enableAutoActivityLifecycleTracing) {
        this.enableAutoActivityLifecycleTracing = enableAutoActivityLifecycleTracing;
    }

    public boolean isEnableActivityLifecycleTracingAutoFinish() {
        return this.enableActivityLifecycleTracingAutoFinish;
    }

    public void setEnableActivityLifecycleTracingAutoFinish(boolean enableActivityLifecycleTracingAutoFinish) {
        this.enableActivityLifecycleTracingAutoFinish = enableActivityLifecycleTracingAutoFinish;
    }

    public boolean isAttachScreenshot() {
        return this.attachScreenshot;
    }

    public void setAttachScreenshot(boolean attachScreenshot) {
        this.attachScreenshot = attachScreenshot;
    }

    public boolean isAttachViewHierarchy() {
        return this.attachViewHierarchy;
    }

    public void setAttachViewHierarchy(boolean attachViewHierarchy) {
        this.attachViewHierarchy = attachViewHierarchy;
    }

    public boolean isCollectAdditionalContext() {
        return this.collectAdditionalContext;
    }

    public void setCollectAdditionalContext(boolean collectAdditionalContext) {
        this.collectAdditionalContext = collectAdditionalContext;
    }

    public boolean isEnableFramesTracking() {
        return this.enableFramesTracking;
    }

    public void setEnableFramesTracking(boolean enableFramesTracking) {
        this.enableFramesTracking = enableFramesTracking;
    }

    @ApiStatus.Internal
    long getStartupCrashFlushTimeoutMillis() {
        return this.startupCrashFlushTimeoutMillis;
    }

    @TestOnly
    void setStartupCrashFlushTimeoutMillis(long startupCrashFlushTimeoutMillis) {
        this.startupCrashFlushTimeoutMillis = startupCrashFlushTimeoutMillis;
    }

    @ApiStatus.Internal
    public long getStartupCrashDurationThresholdMillis() {
        return 2000L;
    }

    @ApiStatus.Internal
    public void setNativeSdkName(@Nullable String nativeSdkName) {
        this.nativeSdkName = nativeSdkName;
    }

    @ApiStatus.Internal
    public void setNativeHandlerStrategy(@NotNull NdkHandlerStrategy ndkHandlerStrategy) {
        this.ndkHandlerStrategy = ndkHandlerStrategy;
    }

    @ApiStatus.Internal
    public int getNdkHandlerStrategy() {
        return this.ndkHandlerStrategy.getValue();
    }

    @ApiStatus.Internal
    @Nullable
    public String getNativeSdkName() {
        return this.nativeSdkName;
    }

    public boolean isEnableRootCheck() {
        return this.enableRootCheck;
    }

    public void setEnableRootCheck(boolean enableRootCheck) {
        this.enableRootCheck = enableRootCheck;
    }

    @Nullable
    public BeforeCaptureCallback getBeforeScreenshotCaptureCallback() {
        return this.beforeScreenshotCaptureCallback;
    }

    public void setBeforeScreenshotCaptureCallback(@NotNull BeforeCaptureCallback beforeScreenshotCaptureCallback) {
        this.beforeScreenshotCaptureCallback = beforeScreenshotCaptureCallback;
    }

    @Nullable
    public BeforeCaptureCallback getBeforeViewHierarchyCaptureCallback() {
        return this.beforeViewHierarchyCaptureCallback;
    }

    public void setBeforeViewHierarchyCaptureCallback(@NotNull BeforeCaptureCallback beforeViewHierarchyCaptureCallback) {
        this.beforeViewHierarchyCaptureCallback = beforeViewHierarchyCaptureCallback;
    }

    public boolean isEnableNdk() {
        return this.enableNdk;
    }

    public void setEnableNdk(boolean enableNdk) {
        this.enableNdk = enableNdk;
    }

    public boolean isEnableScopeSync() {
        return this.enableScopeSync;
    }

    public void setEnableScopeSync(boolean enableScopeSync) {
        this.enableScopeSync = enableScopeSync;
    }

    public boolean isReportHistoricalAnrs() {
        return this.reportHistoricalAnrs;
    }

    public void setReportHistoricalAnrs(boolean reportHistoricalAnrs) {
        this.reportHistoricalAnrs = reportHistoricalAnrs;
    }

    public boolean isAttachAnrThreadDump() {
        return this.attachAnrThreadDump;
    }

    public void setAttachAnrThreadDump(boolean attachAnrThreadDump) {
        this.attachAnrThreadDump = attachAnrThreadDump;
    }

    public boolean isEnablePerformanceV2() {
        return this.enablePerformanceV2;
    }

    public void setEnablePerformanceV2(boolean enablePerformanceV2) {
        this.enablePerformanceV2 = enablePerformanceV2;
    }

    @ApiStatus.Internal
    @Nullable
    public SentryFrameMetricsCollector getFrameMetricsCollector() {
        return this.frameMetricsCollector;
    }

    @ApiStatus.Internal
    public void setFrameMetricsCollector(@Nullable SentryFrameMetricsCollector frameMetricsCollector) {
        this.frameMetricsCollector = frameMetricsCollector;
    }

    public boolean isEnableAutoTraceIdGeneration() {
        return this.enableAutoTraceIdGeneration;
    }

    public void setEnableAutoTraceIdGeneration(boolean enableAutoTraceIdGeneration) {
        this.enableAutoTraceIdGeneration = enableAutoTraceIdGeneration;
    }

    public boolean isEnableSystemEventBreadcrumbsExtras() {
        return this.enableSystemEventBreadcrumbsExtras;
    }

    public void setEnableSystemEventBreadcrumbsExtras(boolean enableSystemEventBreadcrumbsExtras) {
        this.enableSystemEventBreadcrumbsExtras = enableSystemEventBreadcrumbsExtras;
    }

    public static interface BeforeCaptureCallback {
        public boolean execute(@NotNull SentryEvent var1, @NotNull Hint var2, boolean var3);
    }

    static class AndroidUserFeedbackIDialogHandler
    implements SentryFeedbackOptions.IDialogHandler {
        AndroidUserFeedbackIDialogHandler() {
        }

        public void showDialog(@Nullable SentryId associatedEventId, @Nullable SentryFeedbackOptions.OptionsConfigurator configurator) {
            @Nullable Activity activity = CurrentActivityHolder.getInstance().getActivity();
            if (activity == null) {
                Sentry.getCurrentScopes().getOptions().getLogger().log(SentryLevel.ERROR, "Cannot show user feedback dialog, no activity is available. Make sure to call SentryAndroid.init() in your Application.onCreate() method.", new Object[0]);
                return;
            }
            new SentryUserFeedbackDialog.Builder((Context)activity).associatedEventId(associatedEventId).configurator(configurator).create().show();
        }
    }
}

