/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import io.sentry.transport.ICurrentDateProvider;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class Debouncer {
    private final long waitTimeMs;
    @NotNull
    private final ICurrentDateProvider timeProvider;
    @NotNull
    private final AtomicInteger executions = new AtomicInteger(0);
    private final int maxExecutions;
    @NotNull
    private final AtomicLong lastExecutionTime = new AtomicLong(0L);

    public Debouncer(@NotNull ICurrentDateProvider timeProvider, long waitTimeMs, int maxExecutions) {
        this.timeProvider = timeProvider;
        this.waitTimeMs = waitTimeMs;
        this.maxExecutions = maxExecutions <= 0 ? 1 : maxExecutions;
    }

    public boolean checkForDebounce() {
        long now = this.timeProvider.getCurrentTimeMillis();
        if (this.lastExecutionTime.get() == 0L || this.lastExecutionTime.get() + this.waitTimeMs <= now) {
            this.executions.set(0);
            this.lastExecutionTime.set(now);
            return false;
        }
        if (this.executions.incrementAndGet() < this.maxExecutions) {
            return false;
        }
        this.executions.set(0);
        return true;
    }
}

