/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import io.sentry.IScopes;
import io.sentry.Sentry;
import io.sentry.SentryFeedbackOptions;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.R;
import io.sentry.protocol.Feedback;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryUserFeedbackDialog
extends AlertDialog {
    private boolean isCancelable = false;
    @Nullable
    private SentryId currentReplayId;
    @Nullable
    private DialogInterface.OnDismissListener delegate;
    @Nullable
    private final OptionsConfiguration configuration;

    SentryUserFeedbackDialog(@NotNull Context context, int themeResId, @Nullable OptionsConfiguration configuration) {
        super(context, themeResId);
        this.configuration = configuration;
        SentryIntegrationPackageStorage.getInstance().addIntegration("UserFeedbackWidget");
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        this.isCancelable = cancelable;
    }

    protected void onCreate(Bundle savedInstanceState) {
        User user;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sentry_dialog_user_feedback);
        this.setCancelable(this.isCancelable);
        @NotNull SentryFeedbackOptions feedbackOptions = new SentryFeedbackOptions(Sentry.getCurrentScopes().getOptions().getFeedbackOptions());
        if (this.configuration != null) {
            this.configuration.configure(this.getContext(), feedbackOptions);
        }
        @NotNull TextView lblTitle = (TextView)this.findViewById(R.id.sentry_dialog_user_feedback_title);
        @NotNull ImageView imgLogo = (ImageView)this.findViewById(R.id.sentry_dialog_user_feedback_logo);
        @NotNull TextView lblName = (TextView)this.findViewById(R.id.sentry_dialog_user_feedback_txt_name);
        @NotNull EditText edtName = (EditText)this.findViewById(R.id.sentry_dialog_user_feedback_edt_name);
        @NotNull TextView lblEmail = (TextView)this.findViewById(R.id.sentry_dialog_user_feedback_txt_email);
        @NotNull EditText edtEmail = (EditText)this.findViewById(R.id.sentry_dialog_user_feedback_edt_email);
        @NotNull TextView lblMessage = (TextView)this.findViewById(R.id.sentry_dialog_user_feedback_txt_description);
        @NotNull EditText edtMessage = (EditText)this.findViewById(R.id.sentry_dialog_user_feedback_edt_description);
        @NotNull Button btnSend = (Button)this.findViewById(R.id.sentry_dialog_user_feedback_btn_send);
        @NotNull Button btnCancel = (Button)this.findViewById(R.id.sentry_dialog_user_feedback_btn_cancel);
        if (feedbackOptions.isShowBranding()) {
            imgLogo.setVisibility(0);
        } else {
            imgLogo.setVisibility(8);
        }
        if (!feedbackOptions.isShowName() && !feedbackOptions.isNameRequired()) {
            lblName.setVisibility(8);
            edtName.setVisibility(8);
        } else {
            lblName.setVisibility(0);
            edtName.setVisibility(0);
            lblName.setText(feedbackOptions.getNameLabel());
            edtName.setHint(feedbackOptions.getNamePlaceholder());
            if (feedbackOptions.isNameRequired()) {
                lblName.append(feedbackOptions.getIsRequiredLabel());
            }
        }
        if (!feedbackOptions.isShowEmail() && !feedbackOptions.isEmailRequired()) {
            lblEmail.setVisibility(8);
            edtEmail.setVisibility(8);
        } else {
            lblEmail.setVisibility(0);
            edtEmail.setVisibility(0);
            lblEmail.setText(feedbackOptions.getEmailLabel());
            edtEmail.setHint(feedbackOptions.getEmailPlaceholder());
            if (feedbackOptions.isEmailRequired()) {
                lblEmail.append(feedbackOptions.getIsRequiredLabel());
            }
        }
        if (feedbackOptions.isUseSentryUser() && (user = Sentry.getCurrentScopes().getScope().getUser()) != null) {
            edtName.setText((CharSequence)user.getUsername());
            edtEmail.setText((CharSequence)user.getEmail());
        }
        lblMessage.setText(feedbackOptions.getMessageLabel());
        lblMessage.append(feedbackOptions.getIsRequiredLabel());
        edtMessage.setHint(feedbackOptions.getMessagePlaceholder());
        lblTitle.setText(feedbackOptions.getFormTitle());
        btnSend.setText(feedbackOptions.getSubmitButtonLabel());
        btnSend.setOnClickListener(v -> {
            SentryId id2;
            @NotNull String name = edtName.getText().toString().trim();
            @NotNull String email = edtEmail.getText().toString().trim();
            @NotNull String message = edtMessage.getText().toString().trim();
            if (name.isEmpty() && feedbackOptions.isNameRequired()) {
                edtName.setError(lblName.getText());
                return;
            }
            if (email.isEmpty() && feedbackOptions.isEmailRequired()) {
                edtEmail.setError(lblEmail.getText());
                return;
            }
            if (message.isEmpty()) {
                edtMessage.setError(lblMessage.getText());
                return;
            }
            @NotNull Feedback feedback = new Feedback(message);
            feedback.setName(name);
            feedback.setContactEmail(email);
            if (this.currentReplayId != null) {
                feedback.setReplayId(this.currentReplayId);
            }
            if (!(id2 = Sentry.captureFeedback((Feedback)feedback)).equals((Object)SentryId.EMPTY_ID)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)feedbackOptions.getSuccessMessageText(), (int)0).show();
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable SentryFeedbackOptions.SentryFeedbackCallback onSubmitSuccess = feedbackOptions.getOnSubmitSuccess();
                if (onSubmitSuccess != null) {
                    onSubmitSuccess.call(feedback);
                }
            } else {
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable SentryFeedbackOptions.SentryFeedbackCallback onSubmitError = feedbackOptions.getOnSubmitError();
                if (onSubmitError != null) {
                    onSubmitError.call(feedback);
                }
            }
            this.cancel();
        });
        btnCancel.setText(feedbackOptions.getCancelButtonLabel());
        btnCancel.setOnClickListener(v -> this.cancel());
        this.setOnDismissListener(this.delegate);
    }

    public void setOnDismissListener(@Nullable DialogInterface.OnDismissListener listener) {
        this.delegate = listener;
        @NotNull SentryOptions options = Sentry.getCurrentScopes().getOptions();
        @Nullable Runnable onFormClose = options.getFeedbackOptions().getOnFormClose();
        if (onFormClose != null) {
            super.setOnDismissListener(dialog -> {
                onFormClose.run();
                this.currentReplayId = null;
                if (this.delegate != null) {
                    this.delegate.onDismiss(dialog);
                }
            });
        } else {
            super.setOnDismissListener(this.delegate);
        }
    }

    protected void onStart() {
        super.onStart();
        @NotNull SentryOptions options = Sentry.getCurrentScopes().getOptions();
        @NotNull SentryFeedbackOptions feedbackOptions = options.getFeedbackOptions();
        @Nullable Runnable onFormOpen = feedbackOptions.getOnFormOpen();
        if (onFormOpen != null) {
            onFormOpen.run();
        }
        options.getReplayController().captureReplay(Boolean.valueOf(false));
        this.currentReplayId = options.getReplayController().getReplayId();
    }

    public void show() {
        @NotNull IScopes scopes = Sentry.getCurrentScopes();
        @NotNull SentryOptions options = scopes.getOptions();
        if (!scopes.isEnabled() || !options.isEnabled()) {
            options.getLogger().log(SentryLevel.WARNING, "Sentry is disabled. Feedback dialog won't be shown.", new Object[0]);
            return;
        }
        super.show();
    }

    public static interface OptionsConfiguration {
        public void configure(@NotNull Context var1, @NotNull SentryFeedbackOptions var2);
    }

    public static class Builder {
        @Nullable
        OptionsConfiguration configuration;
        @NotNull
        final Context context;
        final int themeResId;

        public Builder(@NotNull Context context) {
            this(context, 0);
        }

        public Builder(Context context, int themeResId) {
            this(context, themeResId, null);
        }

        public Builder(@NotNull Context context, @Nullable OptionsConfiguration configuration) {
            this(context, 0, configuration);
        }

        public Builder(@NotNull Context context, int themeResId, @Nullable OptionsConfiguration configuration) {
            this.context = context;
            this.themeResId = themeResId;
            this.configuration = configuration;
        }

        public SentryUserFeedbackDialog create() {
            return new SentryUserFeedbackDialog(this.context, this.themeResId, this.configuration);
        }
    }
}

