/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.performance;

import io.sentry.android.core.performance.TimeSpan;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ActivityLifecycleTimeSpan
implements Comparable<ActivityLifecycleTimeSpan> {
    @NotNull
    private final TimeSpan onCreate = new TimeSpan();
    @NotNull
    private final TimeSpan onStart = new TimeSpan();

    @NotNull
    public final TimeSpan getOnCreate() {
        return this.onCreate;
    }

    @NotNull
    public final TimeSpan getOnStart() {
        return this.onStart;
    }

    @Override
    public int compareTo(ActivityLifecycleTimeSpan o) {
        int onCreateDiff = Long.compare(this.onCreate.getStartUptimeMs(), o.onCreate.getStartUptimeMs());
        if (onCreateDiff == 0) {
            return Long.compare(this.onStart.getStartUptimeMs(), o.onStart.getStartUptimeMs());
        }
        return onCreateDiff;
    }
}

