/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CurrentActivityHolder {
    @NotNull
    private static final CurrentActivityHolder instance = new CurrentActivityHolder();
    @Nullable
    private WeakReference<Activity> currentActivity;

    private CurrentActivityHolder() {
    }

    @NonNull
    public static CurrentActivityHolder getInstance() {
        return instance;
    }

    @Nullable
    public Activity getActivity() {
        if (this.currentActivity != null) {
            return (Activity)this.currentActivity.get();
        }
        return null;
    }

    public void setActivity(@NonNull Activity activity) {
        if (this.currentActivity != null && this.currentActivity.get() == activity) {
            return;
        }
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    public void clearActivity() {
        this.currentActivity = null;
    }
}

