/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.os.Looper;
import io.sentry.protocol.SentryThread;
import io.sentry.util.thread.IMainThreadChecker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AndroidMainThreadChecker
implements IMainThreadChecker {
    private static final AndroidMainThreadChecker instance = new AndroidMainThreadChecker();

    public static AndroidMainThreadChecker getInstance() {
        return instance;
    }

    private AndroidMainThreadChecker() {
    }

    public boolean isMainThread(long threadId) {
        return Looper.getMainLooper().getThread().getId() == threadId;
    }

    public boolean isMainThread(@NotNull Thread thread) {
        return this.isMainThread(thread.getId());
    }

    public boolean isMainThread() {
        return this.isMainThread(Thread.currentThread());
    }

    public boolean isMainThread(@NotNull SentryThread sentryThread) {
        Long threadId = sentryThread.getId();
        return threadId != null && this.isMainThread(threadId);
    }
}

