/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class Installation {
    @TestOnly
    @Nullable
    static String deviceId = null;
    @TestOnly
    static final String INSTALLATION = "INSTALLATION";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private Installation() {
    }

    public static synchronized String id(@NotNull Context context) throws RuntimeException {
        if (deviceId == null) {
            File installation = new File(context.getFilesDir(), INSTALLATION);
            try {
                if (!installation.exists()) {
                    deviceId = Installation.writeInstallationFile(installation);
                    return deviceId;
                }
                deviceId = Installation.readInstallationFile(installation);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return deviceId;
    }

    @TestOnly
    @NotNull
    static String readInstallationFile(@NotNull File installation) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(installation, "r");){
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            String string = new String(bytes, UTF_8);
            return string;
        }
    }

    @TestOnly
    @NotNull
    static String writeInstallationFile(@NotNull File installation) throws IOException {
        try (FileOutputStream out = new FileOutputStream(installation);){
            String id = UUID.randomUUID().toString();
            ((OutputStream)out).write(id.getBytes(UTF_8));
            out.flush();
            String string = id;
            return string;
        }
    }
}

