/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.LocaleList;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.DisplayMetrics;
import io.sentry.android.core.util.Permissions;
import io.sentry.core.DateUtils;
import io.sentry.core.EventProcessor;
import io.sentry.core.ILogger;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.protocol.App;
import io.sentry.core.protocol.DebugImage;
import io.sentry.core.protocol.DebugMeta;
import io.sentry.core.protocol.Device;
import io.sentry.core.protocol.OperatingSystem;
import io.sentry.core.protocol.SdkVersion;
import io.sentry.core.protocol.User;
import io.sentry.core.util.Objects;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

public final class DefaultAndroidEventProcessor
implements EventProcessor {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    final Context context;
    private final SentryOptions options;
    private static final Date appStartTime = DateUtils.getCurrentDateTime();

    public DefaultAndroidEventProcessor(Context context, SentryOptions options) {
        this.context = (Context)Objects.requireNonNull((Object)(context != null ? context.getApplicationContext() : null), (String)"The application context is required.");
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"The SentryOptions is required.");
    }

    public SentryEvent process(SentryEvent event, @Nullable Object hint) {
        PackageInfo packageInfo;
        if (event.getSdk() == null) {
            event.setSdk(this.getSdkVersion());
        }
        if (event.getUser() == null) {
            event.setUser(this.getUser());
        }
        if ((packageInfo = this.getPackageInfo()) != null) {
            if (event.getRelease() == null) {
                event.setRelease(packageInfo.packageName + "-" + packageInfo.versionName);
            }
            if (event.getDist() == null) {
                event.setDist(this.getVersionCode(packageInfo));
            }
            if (event.getContexts().getApp() == null) {
                event.getContexts().setApp(this.getApp(packageInfo));
            }
        }
        this.setAppExtras(event);
        if (event.getDebugMeta() == null) {
            event.setDebugMeta(this.getDebugMeta());
        }
        if (event.getContexts().getDevice() == null) {
            event.getContexts().setDevice(this.getDevice());
        }
        if (event.getContexts().getOperatingSystem() == null) {
            event.getContexts().setOperatingSystem(this.getOperatingSystem());
        }
        return event;
    }

    private List<DebugImage> getDebugImages() {
        String[] uuids = this.getProGuardUuids();
        if (uuids == null || uuids.length == 0) {
            return null;
        }
        ArrayList<DebugImage> images = new ArrayList<DebugImage>();
        for (String item : uuids) {
            DebugImage debugImage = new DebugImage();
            debugImage.setType("proguard");
            debugImage.setUuid(item);
            images.add(debugImage);
        }
        return images;
    }

    private DebugMeta getDebugMeta() {
        List<DebugImage> debugImages = this.getDebugImages();
        if (debugImages == null) {
            return null;
        }
        DebugMeta debugMeta = new DebugMeta();
        debugMeta.setImages(debugImages);
        return debugMeta;
    }

    private void setAppExtras(SentryEvent event) {
        App app = event.getContexts().getApp();
        if (event.getContexts().getApp() == null) {
            app = new App();
        }
        app.setAppName(this.getApplicationName());
        app.setAppStartTime(appStartTime);
    }

    private SdkVersion getSdkVersion() {
        SdkVersion sdkVersion = new SdkVersion();
        sdkVersion.setName("sentry.java.android");
        String version = "2.0.0-alpha04";
        sdkVersion.setVersion(version);
        sdkVersion.addPackage("sentry-core", version);
        sdkVersion.addPackage("sentry-android-core", version);
        if (this.options.isEnableNdk()) {
            sdkVersion.addPackage("sentry-android-ndk", version);
        }
        return sdkVersion;
    }

    private String getVersionCode(PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Long.toString(packageInfo.getLongVersionCode());
        }
        return this.getVersionCodeDep(packageInfo);
    }

    private String getVersionCodeDep(PackageInfo packageInfo) {
        return Integer.toString(packageInfo.versionCode);
    }

    private String getAbi() {
        return Build.CPU_ABI;
    }

    private String getAbi2() {
        return Build.CPU_ABI2;
    }

    private PackageInfo getPackageInfo() {
        try {
            return this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting package info.", e);
            return null;
        }
    }

    private void setArchitectures(Device device) {
        if (Build.VERSION.SDK_INT >= 21) {
            String[] supportedAbis = Build.SUPPORTED_ABIS;
            device.setArch(supportedAbis[0]);
            device.setArchs(supportedAbis);
        } else {
            String[] supportedAbis = new String[]{this.getAbi(), this.getAbi2()};
            device.setArch(supportedAbis[0]);
            device.setArchs(supportedAbis);
        }
    }

    private Long getMemorySize(ActivityManager.MemoryInfo memInfo) {
        if (Build.VERSION.SDK_INT >= 16) {
            return memInfo.totalMem;
        }
        return Runtime.getRuntime().totalMemory();
    }

    private Device getDevice() {
        DisplayMetrics displayMetrics;
        Device device = new Device();
        device.setName(this.getDeviceName());
        device.setManufacturer(Build.MANUFACTURER);
        device.setBrand(Build.BRAND);
        device.setFamily(this.getFamily());
        device.setModel(Build.MODEL);
        device.setModelId(Build.ID);
        this.setArchitectures(device);
        Intent batteryIntent = this.getBatteryIntent();
        if (batteryIntent != null) {
            device.setBatteryLevel(this.getBatteryLevel(batteryIntent));
            device.setCharging(this.isCharging(batteryIntent));
        }
        device.setOnline(this.isConnected());
        device.setOrientation(this.getOrientation());
        device.setSimulator(this.isEmulator());
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (memInfo != null) {
            device.setMemorySize(this.getMemorySize(memInfo));
            device.setFreeMemory(Long.valueOf(memInfo.availMem));
            device.setLowMemory(Boolean.valueOf(memInfo.lowMemory));
        }
        StatFs internalStorageStat = this.getInternalStorageStat();
        device.setStorageSize(this.getTotalInternalStorage(internalStorageStat));
        device.setFreeStorage(this.getUnusedInternalStorage(internalStorageStat));
        StatFs externalStorageStat = this.getExternalStorageStat();
        if (externalStorageStat != null) {
            device.setExternalStorageSize(this.getTotalExternalStorage(externalStorageStat));
            device.setExternalFreeStorage(this.getUnusedExternalStorage(externalStorageStat));
        }
        if ((displayMetrics = this.getDisplayMetrics()) != null) {
            this.setScreenResolution(device, displayMetrics);
            device.setScreenWidthPixels(Integer.valueOf(displayMetrics.widthPixels));
            device.setScreenHeightPixels(Integer.valueOf(displayMetrics.heightPixels));
            device.setScreenDensity(Float.valueOf(displayMetrics.density));
            device.setScreenDpi(Integer.valueOf(displayMetrics.densityDpi));
        }
        device.setBootTime(this.getBootTime());
        device.setTimezone(this.getTimeZone());
        return device;
    }

    private String getDeviceName() {
        if (Build.VERSION.SDK_INT >= 17) {
            return Settings.Global.getString((ContentResolver)this.context.getContentResolver(), (String)"device_name");
        }
        return null;
    }

    private void setScreenResolution(Device device, DisplayMetrics displayMetrics) {
        device.setScreenResolution(this.getResolution(displayMetrics));
    }

    private TimeZone getTimeZone() {
        LocaleList locales;
        if (Build.VERSION.SDK_INT >= 24 && !(locales = this.context.getResources().getConfiguration().getLocales()).isEmpty()) {
            Locale locale = locales.get(0);
            return Calendar.getInstance(locale).getTimeZone();
        }
        return Calendar.getInstance().getTimeZone();
    }

    private Date getBootTime() {
        return new Date(System.currentTimeMillis() - SystemClock.elapsedRealtime());
    }

    private String getResolution(DisplayMetrics displayMetrics) {
        int largestSide = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
        int smallestSide = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
        return largestSide + "x" + smallestSide;
    }

    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }

    private Intent getBatteryIntent() {
        return this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
    }

    private String getFamily() {
        try {
            return Build.MODEL.split(" ", -1)[0];
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting device family.", e);
            return null;
        }
    }

    private Float getBatteryLevel(Intent batteryIntent) {
        try {
            int level = batteryIntent.getIntExtra("level", -1);
            int scale = batteryIntent.getIntExtra("scale", -1);
            if (level == -1 || scale == -1) {
                return null;
            }
            float percentMultiplier = 100.0f;
            return Float.valueOf((float)level / (float)scale * percentMultiplier);
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting device battery level.", e);
            return null;
        }
    }

    private Boolean isCharging(Intent batteryIntent) {
        try {
            int plugged = batteryIntent.getIntExtra("plugged", -1);
            return plugged == 1 || plugged == 2;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting device charging state.", e);
            return null;
        }
    }

    private Boolean isConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        if (connectivityManager == null) {
            this.log(SentryLevel.INFO, "ConnectivityManager is null and cannot check network status", new Object[0]);
            return null;
        }
        return this.getActiveNetworkInfo(connectivityManager);
    }

    private Boolean getActiveNetworkInfo(ConnectivityManager connectivityManager) {
        if (!Permissions.hasPermission(this.context, "android.permission.ACCESS_NETWORK_STATE")) {
            this.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return null;
        }
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        if (activeNetwork != null) {
            return activeNetwork.isConnected();
        }
        this.log(SentryLevel.INFO, "NetworkInfo is null and cannot check network status", new Object[0]);
        return null;
    }

    private Device.DeviceOrientation getOrientation() {
        try {
            switch (this.context.getResources().getConfiguration().orientation) {
                case 2: {
                    return Device.DeviceOrientation.LANDSCAPE;
                }
                case 1: {
                    return Device.DeviceOrientation.PORTRAIT;
                }
            }
            this.log(SentryLevel.INFO, "No device orientation available (ORIENTATION_UNDEFINED)", new Object[0]);
            return null;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting device orientation.", e);
            return null;
        }
    }

    private Boolean isEmulator() {
        try {
            return Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.HARDWARE.contains("goldfish") || Build.HARDWARE.contains("ranchu") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.PRODUCT.contains("sdk_google") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("sdk_x86") || Build.PRODUCT.contains("vbox86p") || Build.PRODUCT.contains("emulator") || Build.PRODUCT.contains("simulator");
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error checking whether application is running in an emulator.", e);
            return null;
        }
    }

    private Long getTotalInternalStorage(StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long totalBlocks = this.getBlockCountLong(stat);
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting total internal storage amount.", e);
            return null;
        }
    }

    private long getBlockSizeLong(StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getBlockSizeLong();
        }
        return this.getBlockSizeDep(stat);
    }

    private int getBlockSizeDep(StatFs stat) {
        return stat.getBlockSize();
    }

    private long getBlockCountLong(StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getBlockCountLong();
        }
        return this.getBlockCountDep(stat);
    }

    private int getBlockCountDep(StatFs stat) {
        return stat.getBlockCount();
    }

    private long getAvailableBlocksLong(StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getAvailableBlocksLong();
        }
        return this.getAvailableBlocksDep(stat);
    }

    private int getAvailableBlocksDep(StatFs stat) {
        return stat.getAvailableBlocks();
    }

    private Long getUnusedInternalStorage(StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long availableBlocks = this.getAvailableBlocksLong(stat);
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting unused internal storage amount.", e);
            return null;
        }
    }

    private StatFs getInternalStorageStat() {
        File path = Environment.getDataDirectory();
        return new StatFs(path.getPath());
    }

    private StatFs getExternalStorageStat() {
        if (!this.isExternalStorageMounted()) {
            File path = this.getExternalStorageDep();
            if (path != null) {
                return new StatFs(path.getPath());
            }
            this.log(SentryLevel.INFO, "Not possible to read external files directory", new Object[0]);
            return null;
        }
        this.log(SentryLevel.INFO, "External storage is not mounted or emulated.", new Object[0]);
        return null;
    }

    private File getExternalStorageDep() {
        return Environment.getExternalStorageDirectory();
    }

    private Long getTotalExternalStorage(StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long totalBlocks = this.getBlockCountLong(stat);
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting total external storage amount.", e);
            return null;
        }
    }

    private boolean isExternalStorageMounted() {
        return Environment.getExternalStorageState().equals("mounted") && !Environment.isExternalStorageEmulated();
    }

    private Long getUnusedExternalStorage(StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long availableBlocks = this.getAvailableBlocksLong(stat);
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting unused external storage amount.", e);
            return null;
        }
    }

    private DisplayMetrics getDisplayMetrics() {
        try {
            return this.context.getResources().getDisplayMetrics();
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting DisplayMetrics.", e);
            return null;
        }
    }

    private OperatingSystem getOperatingSystem() {
        OperatingSystem os = new OperatingSystem();
        os.setName("Android");
        os.setVersion(Build.VERSION.RELEASE);
        os.setBuild(Build.DISPLAY);
        os.setKernelVersion(this.getKernelVersion());
        os.setRooted(this.isRooted());
        return os;
    }

    private App getApp(PackageInfo packageInfo) {
        App app = new App();
        app.setAppIdentifier(packageInfo.packageName);
        app.setAppVersion(packageInfo.versionName);
        app.setAppBuild(this.getVersionCode(packageInfo));
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKernelVersion() {
        String errorMsg = "Exception while attempting to read kernel information";
        String defaultVersion = System.getProperty("os.version");
        BufferedReader br = null;
        try {
            File file = new File("/proc/version");
            if (!file.canRead()) {
                String string = defaultVersion;
                return string;
            }
            br = Build.VERSION.SDK_INT >= 26 ? Files.newBufferedReader(file.toPath(), UTF_8) : new BufferedReader(new FileReader(file));
            String string = br.readLine();
            return string;
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, errorMsg, e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    this.log(SentryLevel.ERROR, errorMsg, ioe);
                }
            }
        }
        return defaultVersion;
    }

    private Boolean isRooted() {
        String[] probableRootPaths;
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        for (String probableRootPath : probableRootPaths = new String[]{"/data/local/bin/su", "/data/local/su", "/data/local/xbin/su", "/sbin/su", "/su/bin", "/su/bin/su", "/system/app/SuperSU", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/Superuser.apk", "/system/bin/failsafe/su", "/system/bin/su", "/system/sd/xbin/su", "/system/xbin/daemonsu", "/system/xbin/su"}) {
            try {
                if (!new File(probableRootPath).exists()) continue;
                return true;
            }
            catch (Exception e) {
                this.log(SentryLevel.ERROR, "Exception while attempting to detect whether the device is rooted", e);
            }
        }
        return false;
    }

    private String getApplicationName() {
        try {
            ApplicationInfo applicationInfo = this.context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            if (stringId == 0) {
                if (applicationInfo.nonLocalizedLabel != null) {
                    return applicationInfo.nonLocalizedLabel.toString();
                }
                return this.context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            return this.context.getString(stringId);
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting application name.", e);
            return null;
        }
    }

    public User getUser() {
        User user = new User();
        user.setId(this.getAndroidId());
        return user;
    }

    private String getAndroidId() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getProGuardUuids() {
        InputStream is = null;
        try {
            AssetManager assets = this.context.getAssets();
            is = assets.open("sentry-debug-meta.properties");
            Properties properties = new Properties();
            properties.load(is);
            is.close();
            String uuid = properties.getProperty("io.sentry.ProguardUuids");
            if (uuid != null && !uuid.isEmpty()) {
                String[] stringArray = uuid.split("\\|");
                return stringArray;
            }
            this.log(SentryLevel.INFO, "io.sentry.ProguardUuids property was not found.", new Object[0]);
        }
        catch (FileNotFoundException e) {
            this.log(SentryLevel.ERROR, "Proguard UUIDs file not found.", e);
        }
        catch (Exception e) {
            this.log(SentryLevel.ERROR, "Error getting Proguard UUIDs.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.log(SentryLevel.ERROR, "InputStream of sentry-debug-meta.properties didn't close correctly.", e);
                }
            }
        }
        return null;
    }

    private void log(SentryLevel level, String message, Throwable throwable) {
        ILogger logger = this.options.getLogger();
        if (this.options.isDebug()) {
            logger.log(level, message, throwable);
        }
    }

    private void log(SentryLevel level, String message, Object ... args) {
        ILogger logger = this.options.getLogger();
        if (this.options.isDebug()) {
            logger.log(level, message, args);
        }
    }
}

