/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.Debug;
import io.sentry.android.core.ApplicationNotResponding;
import io.sentry.android.core.IHandler;
import io.sentry.android.core.MainLooperHandler;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

final class ANRWatchDog
extends Thread {
    private boolean reportInDebug;
    private ANRListener anrListener;
    private final IHandler uiHandler;
    private final long timeoutIntervalMills;
    private ILogger logger;
    private AtomicLong tick = new AtomicLong(0L);
    private volatile boolean reported = false;
    private final Runnable ticker = () -> {
        this.tick = new AtomicLong(0L);
        this.reported = false;
    };

    ANRWatchDog(long timeoutIntervalMills, boolean reportInDebug, @NotNull ANRListener listener, @NotNull ILogger logger) {
        this(timeoutIntervalMills, reportInDebug, listener, logger, new MainLooperHandler());
    }

    ANRWatchDog(long timeoutIntervalMills, boolean reportInDebug, @NotNull ANRListener listener, @NotNull ILogger logger, @NotNull IHandler uiHandler) {
        this.reportInDebug = reportInDebug;
        this.anrListener = listener;
        this.timeoutIntervalMills = timeoutIntervalMills;
        this.logger = logger;
        this.uiHandler = uiHandler;
    }

    @Override
    public void run() {
        this.setName("|ANR-WatchDog|");
        long interval = this.timeoutIntervalMills;
        while (!this.isInterrupted()) {
            boolean needPost = this.tick.get() == 0L;
            this.tick.addAndGet(interval);
            if (needPost) {
                this.uiHandler.post(this.ticker);
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                this.logger.log(SentryLevel.WARNING, "Interrupted: %s", new Object[]{e.getMessage()});
                return;
            }
            if (this.tick.get() == 0L || this.reported) continue;
            if (!this.reportInDebug && (Debug.isDebuggerConnected() || Debug.waitingForDebugger())) {
                this.logger.log(SentryLevel.DEBUG, "An ANR was detected but ignored because the debugger is connected.", new Object[0]);
                this.reported = true;
                continue;
            }
            this.logger.log(SentryLevel.INFO, "Raising ANR", new Object[0]);
            String message = "Application Not Responding for at least " + this.timeoutIntervalMills + " ms.";
            ApplicationNotResponding error = new ApplicationNotResponding(message, this.uiHandler.getThread());
            this.anrListener.onAppNotResponding(error);
            interval = this.timeoutIntervalMills;
            this.reported = true;
        }
    }

    public static interface ANRListener {
        public void onAppNotResponding(ApplicationNotResponding var1);
    }
}

